% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_2d_gaussian.R
\name{generate_2d_gaussian}
\alias{generate_2d_gaussian}
\title{Generate 2D Gaussian Distribution}
\usage{
generate_2d_gaussian(
  sd = 1,
  power = 1,
  dim = c(11, 11),
  width = 3,
  rescale_unity = FALSE
)
}
\arguments{
\item{sd}{Default \code{1}. Standard deviation of the normal distribution}

\item{power}{Default \code{1}. Power to take the distribution. Higher values will result in a sharper peak.}

\item{dim}{Default \code{c(11, 11)}. The dimensions of the matrix.}

\item{width}{Default \code{3} (\code{-10} to \code{10}). The range in which to compute the distribution.}

\item{rescale_unity}{Default \code{FALSE}. If \code{TRUE}, this will rescale the max value to one. Useful
if wanting to plot the distribution with \code{plot_image()}.}
}
\description{
Generates a 2D gaussian distribution, with an optional
argument to take the gaussian to a user-defined power.
}
\examples{
if(rayimage:::run_documentation()){
image(generate_2d_gaussian(1,1,31), asp=1)
}
}
