% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textstat-methods.R
\name{textstat_select}
\alias{textstat_select}
\title{Select rows of textstat objects by glob, regex or fixed patterns}
\usage{
textstat_select(
  x,
  pattern = NULL,
  selection = c("keep", "remove"),
  valuetype = c("glob", "regex", "fixed"),
  case_insensitive = TRUE
)
}
\arguments{
\item{x}{a \code{textstat} object}

\item{pattern}{see \link[quanteda:pattern]{quanteda::pattern}}

\item{selection}{whether to \code{"keep"} or \code{"remove"} the rows that
match the pattern}

\item{valuetype}{the type of pattern matching: \code{"glob"} for "glob"-style
wildcard expressions; \code{"regex"} for regular expressions; or \code{"fixed"} for
exact matching. See \link[quanteda]{valuetype} for details.}

\item{case_insensitive}{logical; if \code{TRUE}, ignore case when matching a
\code{pattern} or \link[quanteda]{dictionary} values}
}
\description{
Users can subset output object of \code{textstat_collocations},
\code{textstat_keyness} or \code{textstat_frequency} based on
\code{"glob"}, \code{"regex"} or \code{"fixed"} patterns using this method.
}
\examples{
library("quanteda")

period <- ifelse(docvars(data_corpus_inaugural, "Year") < 1945, "pre-war", "post-war")
dfmat <- tokens(data_corpus_inaugural) \%>\%
    dfm() \%>\%
    dfm_group(groups = period)
tstat <- textstat_keyness(dfmat)
textstat_select(tstat, 'america*')

}
\keyword{internal}
\keyword{textstat}
