% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textstat_readability.R
\docType{data}
\name{data_char_wordlists}
\alias{data_char_wordlists}
\title{Word lists for readability statistics}
\format{
A list of length two:
\describe{
\item{\code{DaleChall}}{The long Dale-Chall list of 3,000 familiar (English)
words needed to compute the Dale-Chall Readability Formula.}
\item{\code{Spache}}{The revised Spache word list (see Klare 1975, 73; Spache
1974) needed to compute the Spache Revised Formula of readability (Spache
1953).}
}
}
\usage{
data_char_wordlists
}
\description{
\code{data_char_wordlists} provides word lists used in some readability indexes;
it is a named list of character vectors where each list element
corresponds to a different readability index.
}
\references{
Chall, J.S., & Dale, E. (1995). \emph{Readability Revisited: The New
Dale-Chall Readability Formula}. Brookline Books.

Dale, E. & Chall, J.S. (1948). A Formula for Predicting
Readability. \emph{Educational Research Bulletin}, 27(1): 11--20.

Dale, E. & Chall, J.S. (1948). A Formula for Predicting Readability:
Instructions. \emph{Educational Research Bulletin}, 27(2): 37--54.

Klare, G.R. (1975). Assessing Readability. \emph{Reading Research Quarterly}
10(1), 62--102.

Spache, G. (1953). A New Readability Formula for Primary-Grade Reading
Materials. \emph{The Elementary School Journal}, 53, 410--413.

Spache, G. (1974).  \emph{Good reading for poor readers}. (Rvd. 9th Ed.)
Champaign, Illinois: Garrard, 1974.
}
\keyword{datasets}
