% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workhorses.R
\docType{methods}
\name{skeleton}
\alias{skeleton}
\alias{skeleton,ANY-method}
\alias{skeleton,missing-method}
\alias{skeleton,pomp-method}
\title{skeleton}
\usage{
\S4method{skeleton}{pomp}(
  object,
  x = states(object),
  times = time(object),
  params = coef(object),
  ...
)
}
\arguments{
\item{object}{an object of class \sQuote{pomp}, or of a class that extends \sQuote{pomp}.
This will typically be the output of \code{pomp}, \code{simulate}, or one of the \pkg{pomp} inference algorithms.}

\item{x}{an array containing states of the unobserved process.
The dimensions of \code{x} are \code{nvars} x \code{nrep} x \code{ntimes},
where \code{nvars} is the number of state variables,
\code{nrep} is the number of replicates,
and \code{ntimes} is the length of \code{times}.
One can also pass \code{x} as a named numeric vector, which is equivalent to the \code{nrep=1}, \code{ntimes=1} case.}

\item{times}{a numeric vector (length \code{ntimes}) containing times.
These must be in non-decreasing order.}

\item{params}{a \code{npar} x \code{nrep} matrix of parameters.
Each column is treated as an independent parameter set, in correspondence with the corresponding column of \code{x}.}

\item{...}{additional arguments are ignored.}
}
\value{
\code{skeleton} returns an array of dimensions \code{nvar} x \code{nrep} x \code{ntimes}.
If \code{f} is the returned matrix, \code{f[i,j,k]} is the i-th component of the deterministic skeleton at time \code{times[k]} given the state \code{x[,j,k]} and parameters \code{params[,j]}.
}
\description{
Evaluates the deterministic skeleton at a point or points in state space, given parameters.
In the case of a discrete-time system, the skeleton is a map.
In the case of a continuous-time system, the skeleton is a vectorfield.
NB: \code{skeleton} just evaluates the deterministic skeleton;
it does not iterate or integrate (see \code{\link{trajectory}} for this).
}
\seealso{
Specification of the deterministic skeleton: \link{skeleton specification}

More on \pkg{pomp} workhorse functions: 
\code{\link{dmeasure}()},
\code{\link{dprior}()},
\code{\link{dprocess}()},
\code{\link{emeasure}()},
\code{\link{flow}()},
\code{\link{partrans}()},
\code{\link{pomp-package}},
\code{\link{rinit}()},
\code{\link{rmeasure}()},
\code{\link{rprior}()},
\code{\link{rprocess}()},
\code{\link{vmeasure}()},
\code{\link{workhorses}}

More on methods for deterministic process models: 
\code{\link{flow}()},
\code{\link{skeleton specification}},
\code{\link{trajectory matching}},
\code{\link{trajectory}()}
}
\concept{deterministic methods}
\concept{extending the pomp package}
\concept{low-level interface}
\concept{pomp workhorses}
