// Generated by rstantools.  Do not edit by hand.

/*
    pcFactorStan is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    pcFactorStan is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pcFactorStan.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_correlation_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'correlation', line 134, column 2 to column 56)",
                                                      " (in 'correlation', line 135, column 2 to column 32)",
                                                      " (in 'correlation', line 136, column 2 to column 35)",
                                                      " (in 'correlation', line 137, column 2 to column 47)",
                                                      " (in 'correlation', line 140, column 2 to column 36)",
                                                      " (in 'correlation', line 141, column 2 to column 35)",
                                                      " (in 'correlation', line 142, column 2 to column 32)",
                                                      " (in 'correlation', line 145, column 4 to column 53)",
                                                      " (in 'correlation', line 144, column 20 to line 146, column 3)",
                                                      " (in 'correlation', line 144, column 2 to line 146, column 3)",
                                                      " (in 'correlation', line 148, column 4 to column 53)",
                                                      " (in 'correlation', line 149, column 4 to column 27)",
                                                      " (in 'correlation', line 150, column 4 to column 43)",
                                                      " (in 'correlation', line 151, column 4 to column 57)",
                                                      " (in 'correlation', line 152, column 4 to column 59)",
                                                      " (in 'correlation', line 147, column 23 to line 153, column 3)",
                                                      " (in 'correlation', line 147, column 2 to line 153, column 3)",
                                                      " (in 'correlation', line 176, column 2 to column 31)",
                                                      " (in 'correlation', line 177, column 2 to column 64)",
                                                      " (in 'correlation', line 156, column 2 to column 51)",
                                                      " (in 'correlation', line 158, column 4 to column 33)",
                                                      " (in 'correlation', line 157, column 20 to line 159, column 3)",
                                                      " (in 'correlation', line 157, column 2 to line 159, column 3)",
                                                      " (in 'correlation', line 160, column 2 to column 30)",
                                                      " (in 'correlation', line 161, column 68 to column 69)",
                                                      " (in 'correlation', line 161, column 23 to column 72)",
                                                      " (in 'correlation', line 161, column 2 to column 72)",
                                                      " (in 'correlation', line 163, column 4 to column 21)",
                                                      " (in 'correlation', line 165, column 6 to column 24)",
                                                      " (in 'correlation', line 166, column 6 to column 29)",
                                                      " (in 'correlation', line 167, column 6 to column 45)",
                                                      " (in 'correlation', line 168, column 6 to line 170, column 72)",
                                                      " (in 'correlation', line 171, column 6 to column 30)",
                                                      " (in 'correlation', line 164, column 29 to line 172, column 5)",
                                                      " (in 'correlation', line 164, column 4 to line 172, column 5)",
                                                      " (in 'correlation', line 162, column 2 to line 173, column 3)",
                                                      " (in 'correlation', line 99, column 2 to column 23)",
                                                      " (in 'correlation', line 101, column 2 to column 19)",
                                                      " (in 'correlation', line 102, column 2 to column 20)",
                                                      " (in 'correlation', line 103, column 2 to column 17)",
                                                      " (in 'correlation', line 104, column 2 to column 26)",
                                                      " (in 'correlation', line 105, column 2 to column 22)",
                                                      " (in 'correlation', line 106, column 8 to column 14)",
                                                      " (in 'correlation', line 106, column 2 to column 37)",
                                                      " (in 'correlation', line 107, column 8 to column 14)",
                                                      " (in 'correlation', line 107, column 2 to column 37)",
                                                      " (in 'correlation', line 108, column 9 to column 15)",
                                                      " (in 'correlation', line 108, column 2 to column 23)",
                                                      " (in 'correlation', line 109, column 2 to column 19)",
                                                      " (in 'correlation', line 111, column 8 to column 18)",
                                                      " (in 'correlation', line 111, column 2 to column 48)",
                                                      " (in 'correlation', line 112, column 8 to column 18)",
                                                      " (in 'correlation', line 112, column 2 to column 48)",
                                                      " (in 'correlation', line 113, column 8 to column 12)",
                                                      " (in 'correlation', line 113, column 2 to column 25)",
                                                      " (in 'correlation', line 114, column 8 to column 12)",
                                                      " (in 'correlation', line 114, column 2 to column 23)",
                                                      " (in 'correlation', line 115, column 8 to column 18)",
                                                      " (in 'correlation', line 115, column 2 to column 32)",
                                                      " (in 'correlation', line 116, column 8 to column 18)",
                                                      " (in 'correlation', line 116, column 2 to column 35)",
                                                      " (in 'correlation', line 117, column 8 to column 18)",
                                                      " (in 'correlation', line 117, column 2 to column 29)",
                                                      " (in 'correlation', line 120, column 2 to column 37)",
                                                      " (in 'correlation', line 121, column 8 to column 12)",
                                                      " (in 'correlation', line 121, column 2 to column 23)",
                                                      " (in 'correlation', line 123, column 4 to column 21)",
                                                      " (in 'correlation', line 125, column 6 to column 24)",
                                                      " (in 'correlation', line 127, column 8 to column 70)",
                                                      " (in 'correlation', line 126, column 33 to line 128, column 7)",
                                                      " (in 'correlation', line 126, column 6 to line 128, column 7)",
                                                      " (in 'correlation', line 129, column 6 to column 30)",
                                                      " (in 'correlation', line 124, column 29 to line 130, column 5)",
                                                      " (in 'correlation', line 124, column 4 to line 130, column 5)",
                                                      " (in 'correlation', line 122, column 2 to line 131, column 3)",
                                                      " (in 'correlation', line 134, column 26 to column 41)",
                                                      " (in 'correlation', line 135, column 18 to column 24)",
                                                      " (in 'correlation', line 136, column 9 to column 12)",
                                                      " (in 'correlation', line 136, column 13 to column 19)",
                                                      " (in 'correlation', line 137, column 23 to column 29)",
                                                      " (in 'correlation', line 140, column 9 to column 24)",
                                                      " (in 'correlation', line 141, column 9 to column 24)",
                                                      " (in 'correlation', line 142, column 9 to column 12)",
                                                      " (in 'correlation', line 142, column 13 to column 19)",
                                                      " (in 'correlation', line 176, column 14 to column 20)",
                                                      " (in 'correlation', line 19, column 2 to column 30)",
                                                      " (in 'correlation', line 20, column 2 to column 19)",
                                                      " (in 'correlation', line 21, column 8 to column 14)",
                                                      " (in 'correlation', line 21, column 2 to column 24)",
                                                      " (in 'correlation', line 22, column 9 to column 17)",
                                                      " (in 'correlation', line 22, column 2 to column 23)",
                                                      " (in 'correlation', line 23, column 2 to column 44)",
                                                      " (in 'correlation', line 24, column 9 to column 12)",
                                                      " (in 'correlation', line 24, column 2 to column 37)",
                                                      " (in 'correlation', line 25, column 2 to column 17)",
                                                      " (in 'correlation', line 36, column 6 to column 17)",
                                                      " (in 'correlation', line 35, column 11 to line 37, column 5)",
                                                      " (in 'correlation', line 28, column 6 to column 14)",
                                                      " (in 'correlation', line 32, column 8 to column 30)",
                                                      " (in 'correlation', line 31, column 13 to line 33, column 7)",
                                                      " (in 'correlation', line 30, column 8 to column 33)",
                                                      " (in 'correlation', line 29, column 21 to line 31, column 7)",
                                                      " (in 'correlation', line 29, column 6 to line 33, column 7)",
                                                      " (in 'correlation', line 34, column 6 to column 45)",
                                                      " (in 'correlation', line 27, column 32 to line 35, column 5)",
                                                      " (in 'correlation', line 27, column 4 to line 37, column 5)",
                                                      " (in 'correlation', line 26, column 21 to line 38, column 3)",
                                                      " (in 'correlation', line 26, column 2 to line 38, column 3)",
                                                      " (in 'correlation', line 39, column 2 to column 17)",
                                                      " (in 'correlation', line 41, column 4 to column 32)",
                                                      " (in 'correlation', line 40, column 34 to line 42, column 3)",
                                                      " (in 'correlation', line 40, column 2 to line 42, column 3)",
                                                      " (in 'correlation', line 45, column 6 to line 46, column 79)",
                                                      " (in 'correlation', line 44, column 52 to line 47, column 5)",
                                                      " (in 'correlation', line 44, column 4 to line 47, column 5)",
                                                      " (in 'correlation', line 43, column 35 to line 48, column 3)",
                                                      " (in 'correlation', line 43, column 2 to line 48, column 3)",
                                                      " (in 'correlation', line 49, column 2 to column 13)",
                                                      " (in 'correlation', line 18, column 91 to line 50, column 1)",
                                                      " (in 'correlation', line 55, column 2 to column 14)",
                                                      " (in 'correlation', line 56, column 2 to column 32)",
                                                      " (in 'correlation', line 57, column 9 to column 16)",
                                                      " (in 'correlation', line 57, column 2 to column 23)",
                                                      " (in 'correlation', line 58, column 8 to column 15)",
                                                      " (in 'correlation', line 58, column 2 to column 26)",
                                                      " (in 'correlation', line 59, column 35 to column 48)",
                                                      " (in 'correlation', line 59, column 2 to column 48)",
                                                      " (in 'correlation', line 61, column 4 to column 25)",
                                                      " (in 'correlation', line 60, column 44 to line 62, column 3)",
                                                      " (in 'correlation', line 60, column 2 to line 62, column 3)",
                                                      " (in 'correlation', line 63, column 2 to column 56)",
                                                      " (in 'correlation', line 65, column 4 to column 35)",
                                                      " (in 'correlation', line 69, column 6 to column 29)",
                                                      " (in 'correlation', line 68, column 11 to line 70, column 5)",
                                                      " (in 'correlation', line 67, column 6 to column 16)",
                                                      " (in 'correlation', line 66, column 25 to line 68, column 5)",
                                                      " (in 'correlation', line 66, column 4 to line 70, column 5)",
                                                      " (in 'correlation', line 64, column 44 to line 71, column 3)",
                                                      " (in 'correlation', line 64, column 2 to line 71, column 3)",
                                                      " (in 'correlation', line 72, column 2 to column 12)",
                                                      " (in 'correlation', line 54, column 0 to line 73, column 1)",
                                                      " (in 'correlation', line 78, column 8 to column 18)",
                                                      " (in 'correlation', line 78, column 2 to column 28)",
                                                      " (in 'correlation', line 79, column 2 to column 14)",
                                                      " (in 'correlation', line 80, column 2 to column 32)",
                                                      " (in 'correlation', line 81, column 9 to column 16)",
                                                      " (in 'correlation', line 81, column 2 to column 23)",
                                                      " (in 'correlation', line 82, column 8 to column 15)",
                                                      " (in 'correlation', line 82, column 2 to column 26)",
                                                      " (in 'correlation', line 83, column 35 to column 48)",
                                                      " (in 'correlation', line 83, column 2 to column 48)",
                                                      " (in 'correlation', line 85, column 4 to column 25)",
                                                      " (in 'correlation', line 84, column 44 to line 86, column 3)",
                                                      " (in 'correlation', line 84, column 2 to line 86, column 3)",
                                                      " (in 'correlation', line 87, column 2 to column 56)",
                                                      " (in 'correlation', line 89, column 4 to column 35)",
                                                      " (in 'correlation', line 91, column 6 to column 20)",
                                                      " (in 'correlation', line 92, column 6 to column 15)",
                                                      " (in 'correlation', line 90, column 29 to line 93, column 5)",
                                                      " (in 'correlation', line 90, column 4 to line 93, column 5)",
                                                      " (in 'correlation', line 88, column 44 to line 94, column 3)",
                                                      " (in 'correlation', line 88, column 2 to line 94, column 3)",
                                                      " (in 'correlation', line 95, column 2 to column 12)",
                                                      " (in 'correlation', line 77, column 0 to line 96, column 1)"};
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__>
Eigen::Matrix<stan::promote_args_t<T0__, T1__, T2__, T3__,
stan::value_type_t<T4__>>, -1, 1>
cmp_probs(const T0__& scale, const T1__& alpha, const T2__& pa1,
          const T3__& pa2, const T4__& thr_arg__,
          const std::vector<int>& want, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          T1__,
          T2__,
          T3__,
          stan::value_type_t<T4__>>;
  const auto& thr = to_ref(thr_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int nth;
    nth = std::numeric_limits<int>::min();
    
    current_statement__ = 86;
    nth = num_elements(thr);
    int nth2;
    nth2 = std::numeric_limits<int>::min();
    
    current_statement__ = 87;
    nth2 = (nth * 2);
    current_statement__ = 88;
    validate_non_negative_index("pr", "1 + nth2", (1 + nth2));
    std::vector<local_scalar_t__> pr;
    pr = std::vector<local_scalar_t__>((1 + nth2), DUMMY_VAR__);
    
    current_statement__ = 90;
    validate_non_negative_index("out", "1 + nth2", (1 + nth2));
    Eigen::Matrix<local_scalar_t__, -1, 1> out;
    out = Eigen::Matrix<local_scalar_t__, -1, 1>((1 + nth2));
    stan::math::fill(out, DUMMY_VAR__);
    
    local_scalar_t__ paDiff;
    paDiff = DUMMY_VAR__;
    
    current_statement__ = 92;
    paDiff = ((alpha * scale) * (pa1 - pa2));
    current_statement__ = 93;
    validate_non_negative_index("thrAlpha", "nth", nth);
    Eigen::Matrix<local_scalar_t__, -1, 1> thrAlpha;
    thrAlpha = Eigen::Matrix<local_scalar_t__, -1, 1>(nth);
    stan::math::fill(thrAlpha, DUMMY_VAR__);
    
    current_statement__ = 94;
    assign(thrAlpha, nil_index_list(), multiply(thr, alpha),
      "assigning variable thrAlpha");
    current_statement__ = 95;
    assign(pr, cons_list(index_uni((1 + nth2)), nil_index_list()), 1,
      "assigning variable pr");
    current_statement__ = 108;
    for (int tx = 1; tx <= nth2; ++tx) {
      current_statement__ = 106;
      if ((primitive_value(want[(tx - 1)]) || primitive_value(
          want[((tx + 1) - 1)]))) {
        local_scalar_t__ at;
        at = DUMMY_VAR__;
        
        current_statement__ = 103;
        if (logical_lte(tx, nth)) {
          current_statement__ = 101;
          at = -thrAlpha[(((nth + 1) - tx) - 1)];
        } else {
          current_statement__ = 99;
          at = thrAlpha[((tx - nth) - 1)];
        }
        current_statement__ = 104;
        assign(pr, cons_list(index_uni(tx), nil_index_list()),
          (1.0 / (1.0 + stan::math::exp(-(paDiff + at)))),
          "assigning variable pr");
      } else {
        current_statement__ = 96;
        assign(pr, cons_list(index_uni(tx), nil_index_list()), 0,
          "assigning variable pr");
      }}
    current_statement__ = 109;
    assign(out, cons_list(index_uni(1), nil_index_list()), pr[(1 - 1)],
      "assigning variable out");
    current_statement__ = 112;
    for (int tx = 2; tx <= num_elements(out); ++tx) {
      current_statement__ = 110;
      assign(out, cons_list(index_uni(tx), nil_index_list()),
        (pr[(tx - 1)] - pr[((tx - 1) - 1)]), "assigning variable out");}
    current_statement__ = 117;
    for (int tx = 1; tx <= num_elements(want); ++tx) {
      current_statement__ = 115;
      if ((primitive_value(want[(tx - 1)]) && primitive_value(
          (primitive_value(logical_lte(out[(tx - 1)], 0)) || primitive_value(
          logical_gte(out[(tx - 1)], 1)))))) {
        current_statement__ = 113;
        std::stringstream errmsg_stream__;
        errmsg_stream__ << "out[";
        errmsg_stream__ << tx;
        errmsg_stream__ << "]=";
        errmsg_stream__ << out[(tx - 1)];
        errmsg_stream__ << "; scale=";
        errmsg_stream__ << scale;
        errmsg_stream__ << " alpha=";
        errmsg_stream__ << alpha;
        errmsg_stream__ << " pa1=";
        errmsg_stream__ << pa1;
        errmsg_stream__ << " pa2=";
        errmsg_stream__ << pa2;
        errmsg_stream__ << " th=";
        errmsg_stream__ << thr;
        throw std::domain_error(errmsg_stream__.str());
      } }
    current_statement__ = 118;
    return out;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct cmp_probs_functor__ {
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__>
Eigen::Matrix<stan::promote_args_t<T0__, T1__, T2__, T3__,
stan::value_type_t<T4__>>, -1, 1>
operator()(const T0__& scale, const T1__& alpha, const T2__& pa1,
           const T3__& pa2, const T4__& thr, const std::vector<int>& want,
           std::ostream* pstream__)  const 
{
return cmp_probs(scale, alpha, pa1, pa2, thr, want, pstream__);
}
};
template <typename T4__, typename T5__, typename T6__, typename T7__,
typename T8__>
stan::promote_args_t<T4__, T5__, T6__, T7__,
stan::value_type_t<T8__>>
pairwise_logprob(const std::vector<int>& rcat,
                 const std::vector<int>& weight, const int& cmpStart,
                 const int& len, const T4__& scale, const T5__& alpha,
                 const T6__& pa1, const T7__& pa2, const T8__& cumTh_arg__,
                 std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T4__,
          T5__,
          T6__,
          T7__,
          stan::value_type_t<T8__>>;
  const auto& cumTh = to_ref(cumTh_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    local_scalar_t__ lp;
    lp = DUMMY_VAR__;
    
    current_statement__ = 120;
    lp = 0;
    int nth;
    nth = std::numeric_limits<int>::min();
    
    current_statement__ = 121;
    nth = num_elements(cumTh);
    current_statement__ = 122;
    validate_non_negative_index("prob", "1 + nth * 2", (1 + (nth * 2)));
    Eigen::Matrix<local_scalar_t__, -1, 1> prob;
    prob = Eigen::Matrix<local_scalar_t__, -1, 1>((1 + (nth * 2)));
    stan::math::fill(prob, DUMMY_VAR__);
    
    current_statement__ = 124;
    validate_non_negative_index("want", "1 + nth * 2", (1 + (nth * 2)));
    std::vector<int> want;
    want = std::vector<int>((1 + (nth * 2)), std::numeric_limits<int>::min());
    
    current_statement__ = 127;
    for (int ox = 1; ox <= num_elements(want); ++ox) {
      current_statement__ = 126;
      assign(want, cons_list(index_uni(ox), nil_index_list()), 0,
        "assigning variable want");}
    current_statement__ = 130;
    for (int ox = cmpStart; ox <= ((cmpStart + len) - 1); ++ox) {
      current_statement__ = 128;
      assign(want, cons_list(index_uni(rcat[(ox - 1)]), nil_index_list()), 1,
        "assigning variable want");}
    current_statement__ = 131;
    assign(prob, nil_index_list(),
      cmp_probs(scale, alpha, pa1, pa2, cumTh, want, pstream__),
      "assigning variable prob");
    current_statement__ = 139;
    for (int ox = cmpStart; ox <= ((cmpStart + len) - 1); ++ox) {
      local_scalar_t__ lp1;
      lp1 = DUMMY_VAR__;
      
      current_statement__ = 132;
      lp1 = stan::math::log(prob[(rcat[(ox - 1)] - 1)]);
      current_statement__ = 137;
      if (logical_eq(weight[(ox - 1)], 1)) {
        current_statement__ = 135;
        lp = (lp + lp1);
      } else {
        current_statement__ = 133;
        lp = (lp + (weight[(ox - 1)] * lp1));
      }}
    current_statement__ = 140;
    return lp;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct pairwise_logprob_functor__ {
template <typename T4__, typename T5__, typename T6__, typename T7__,
typename T8__>
stan::promote_args_t<T4__, T5__, T6__, T7__,
stan::value_type_t<T8__>>
operator()(const std::vector<int>& rcat, const std::vector<int>& weight,
           const int& cmpStart, const int& len, const T4__& scale,
           const T5__& alpha, const T6__& pa1, const T7__& pa2,
           const T8__& cumTh, std::ostream* pstream__)  const 
{
return pairwise_logprob(rcat, weight, cmpStart, len, scale, alpha, pa1, pa2,
         cumTh, pstream__);
}
};
template <typename T5__, typename T6__, typename T7__, typename T8__,
typename T9__>
std::vector<stan::promote_args_t<T5__, T6__, T7__, T8__,
stan::value_type_t<T9__>>>
pairwise_loo(const std::vector<int>& rcat, const std::vector<int>& weight,
             const int& numOutcome, const int& cmpStart, const int& len,
             const T5__& scale, const T6__& alpha, const T7__& pa1,
             const T8__& pa2, const T9__& cumTh_arg__,
             std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T5__,
          T6__,
          T7__,
          T8__,
          stan::value_type_t<T9__>>;
  const auto& cumTh = to_ref(cumTh_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 142;
    validate_non_negative_index("lp", "numOutcome", numOutcome);
    std::vector<local_scalar_t__> lp;
    lp = std::vector<local_scalar_t__>(numOutcome, DUMMY_VAR__);
    
    int cur;
    cur = std::numeric_limits<int>::min();
    
    current_statement__ = 144;
    cur = 1;
    int nth;
    nth = std::numeric_limits<int>::min();
    
    current_statement__ = 145;
    nth = num_elements(cumTh);
    current_statement__ = 146;
    validate_non_negative_index("prob", "1 + nth * 2", (1 + (nth * 2)));
    Eigen::Matrix<local_scalar_t__, -1, 1> prob;
    prob = Eigen::Matrix<local_scalar_t__, -1, 1>((1 + (nth * 2)));
    stan::math::fill(prob, DUMMY_VAR__);
    
    current_statement__ = 148;
    validate_non_negative_index("want", "1 + nth * 2", (1 + (nth * 2)));
    std::vector<int> want;
    want = std::vector<int>((1 + (nth * 2)), std::numeric_limits<int>::min());
    
    current_statement__ = 151;
    for (int ox = 1; ox <= num_elements(want); ++ox) {
      current_statement__ = 150;
      assign(want, cons_list(index_uni(ox), nil_index_list()), 0,
        "assigning variable want");}
    current_statement__ = 154;
    for (int ox = cmpStart; ox <= ((cmpStart + len) - 1); ++ox) {
      current_statement__ = 152;
      assign(want, cons_list(index_uni(rcat[(ox - 1)]), nil_index_list()), 1,
        "assigning variable want");}
    current_statement__ = 155;
    assign(prob, nil_index_list(),
      cmp_probs(scale, alpha, pa1, pa2, cumTh, want, pstream__),
      "assigning variable prob");
    current_statement__ = 162;
    for (int ox = cmpStart; ox <= ((cmpStart + len) - 1); ++ox) {
      local_scalar_t__ lp1;
      lp1 = DUMMY_VAR__;
      
      current_statement__ = 156;
      lp1 = stan::math::log(prob[(rcat[(ox - 1)] - 1)]);
      current_statement__ = 160;
      for (int wx = 1; wx <= weight[(ox - 1)]; ++wx) {
        current_statement__ = 157;
        assign(lp, cons_list(index_uni(cur), nil_index_list()), lp1,
          "assigning variable lp");
        current_statement__ = 158;
        cur = (cur + 1);}}
    current_statement__ = 163;
    return lp;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct pairwise_loo_functor__ {
template <typename T5__, typename T6__, typename T7__, typename T8__,
typename T9__>
std::vector<stan::promote_args_t<T5__, T6__, T7__, T8__,
stan::value_type_t<T9__>>>
operator()(const std::vector<int>& rcat, const std::vector<int>& weight,
           const int& numOutcome, const int& cmpStart, const int& len,
           const T5__& scale, const T6__& alpha, const T7__& pa1,
           const T8__& pa2, const T9__& cumTh, std::ostream* pstream__)  const 
{
return pairwise_loo(rcat, weight, numOutcome, cmpStart, len, scale, alpha,
         pa1, pa2, cumTh, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_correlation final : public model_base_crtp<model_correlation> {
private:
  double alphaScalePrior;
  int NPA;
  int NCMP;
  int N;
  int numRefresh;
  int NITEMS;
  std::vector<int> NTHRESH;
  std::vector<int> TOFFSET;
  Eigen::Matrix<double, -1, 1> scale;
  double corLKJPrior;
  std::vector<int> pa1;
  std::vector<int> pa2;
  std::vector<int> weight;
  std::vector<int> pick;
  std::vector<int> refresh;
  std::vector<int> numOutcome;
  std::vector<int> item;
  int totalThresholds;
  std::vector<int> rcat;
 
public:
  ~model_correlation() { }
  
  inline std::string model_name() const final { return "model_correlation"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_correlation(stan::io::var_context& context__,
                    unsigned int random_seed__ = 0,
                    std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_correlation_namespace::model_correlation";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 37;
      context__.validate_dims("data initialization","alphaScalePrior",
          "double",context__.to_vec());
      alphaScalePrior = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 37;
      alphaScalePrior = context__.vals_r("alphaScalePrior")[(1 - 1)];
      current_statement__ = 38;
      context__.validate_dims("data initialization","NPA","int",
          context__.to_vec());
      NPA = std::numeric_limits<int>::min();
      
      current_statement__ = 38;
      NPA = context__.vals_i("NPA")[(1 - 1)];
      current_statement__ = 38;
      current_statement__ = 38;
      check_greater_or_equal(function__, "NPA", NPA, 1);
      current_statement__ = 39;
      context__.validate_dims("data initialization","NCMP","int",
          context__.to_vec());
      NCMP = std::numeric_limits<int>::min();
      
      current_statement__ = 39;
      NCMP = context__.vals_i("NCMP")[(1 - 1)];
      current_statement__ = 39;
      current_statement__ = 39;
      check_greater_or_equal(function__, "NCMP", NCMP, 1);
      current_statement__ = 40;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 40;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 40;
      current_statement__ = 40;
      check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 41;
      context__.validate_dims("data initialization","numRefresh","int",
          context__.to_vec());
      numRefresh = std::numeric_limits<int>::min();
      
      current_statement__ = 41;
      numRefresh = context__.vals_i("numRefresh")[(1 - 1)];
      current_statement__ = 41;
      current_statement__ = 41;
      check_greater_or_equal(function__, "numRefresh", numRefresh, 1);
      current_statement__ = 42;
      context__.validate_dims("data initialization","NITEMS","int",
          context__.to_vec());
      NITEMS = std::numeric_limits<int>::min();
      
      current_statement__ = 42;
      NITEMS = context__.vals_i("NITEMS")[(1 - 1)];
      current_statement__ = 42;
      current_statement__ = 42;
      check_greater_or_equal(function__, "NITEMS", NITEMS, 1);
      current_statement__ = 43;
      validate_non_negative_index("NTHRESH", "NITEMS", NITEMS);
      current_statement__ = 44;
      context__.validate_dims("data initialization","NTHRESH","int",
          context__.to_vec(NITEMS));
      NTHRESH = std::vector<int>(NITEMS, std::numeric_limits<int>::min());
      
      current_statement__ = 44;
      assign(NTHRESH, nil_index_list(), context__.vals_i("NTHRESH"),
        "assigning variable NTHRESH");
      current_statement__ = 44;
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        current_statement__ = 44;
        current_statement__ = 44;
        check_greater_or_equal(function__, "NTHRESH[sym1__]",
                               NTHRESH[(sym1__ - 1)], 1);}
      current_statement__ = 45;
      validate_non_negative_index("TOFFSET", "NITEMS", NITEMS);
      current_statement__ = 46;
      context__.validate_dims("data initialization","TOFFSET","int",
          context__.to_vec(NITEMS));
      TOFFSET = std::vector<int>(NITEMS, std::numeric_limits<int>::min());
      
      current_statement__ = 46;
      assign(TOFFSET, nil_index_list(), context__.vals_i("TOFFSET"),
        "assigning variable TOFFSET");
      current_statement__ = 46;
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        current_statement__ = 46;
        current_statement__ = 46;
        check_greater_or_equal(function__, "TOFFSET[sym1__]",
                               TOFFSET[(sym1__ - 1)], 1);}
      current_statement__ = 47;
      validate_non_negative_index("scale", "NITEMS", NITEMS);
      current_statement__ = 48;
      context__.validate_dims("data initialization","scale","double",
          context__.to_vec(NITEMS));
      scale = Eigen::Matrix<double, -1, 1>(NITEMS);
      stan::math::fill(scale, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> scale_flat__;
        current_statement__ = 48;
        assign(scale_flat__, nil_index_list(), context__.vals_r("scale"),
          "assigning variable scale_flat__");
        current_statement__ = 48;
        pos__ = 1;
        current_statement__ = 48;
        for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
          current_statement__ = 48;
          assign(scale, cons_list(index_uni(sym1__), nil_index_list()),
            scale_flat__[(pos__ - 1)], "assigning variable scale");
          current_statement__ = 48;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 49;
      context__.validate_dims("data initialization","corLKJPrior","double",
          context__.to_vec());
      corLKJPrior = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 49;
      corLKJPrior = context__.vals_r("corLKJPrior")[(1 - 1)];
      current_statement__ = 50;
      validate_non_negative_index("pa1", "numRefresh", numRefresh);
      current_statement__ = 51;
      context__.validate_dims("data initialization","pa1","int",
          context__.to_vec(numRefresh));
      pa1 = std::vector<int>(numRefresh, std::numeric_limits<int>::min());
      
      current_statement__ = 51;
      assign(pa1, nil_index_list(), context__.vals_i("pa1"),
        "assigning variable pa1");
      current_statement__ = 51;
      for (int sym1__ = 1; sym1__ <= numRefresh; ++sym1__) {
        current_statement__ = 51;
        current_statement__ = 51;
        check_greater_or_equal(function__, "pa1[sym1__]", pa1[(sym1__ - 1)],
                               1);}
      current_statement__ = 51;
      for (int sym1__ = 1; sym1__ <= numRefresh; ++sym1__) {
        current_statement__ = 51;
        current_statement__ = 51;
        check_less_or_equal(function__, "pa1[sym1__]", pa1[(sym1__ - 1)], NPA);
      }
      current_statement__ = 52;
      validate_non_negative_index("pa2", "numRefresh", numRefresh);
      current_statement__ = 53;
      context__.validate_dims("data initialization","pa2","int",
          context__.to_vec(numRefresh));
      pa2 = std::vector<int>(numRefresh, std::numeric_limits<int>::min());
      
      current_statement__ = 53;
      assign(pa2, nil_index_list(), context__.vals_i("pa2"),
        "assigning variable pa2");
      current_statement__ = 53;
      for (int sym1__ = 1; sym1__ <= numRefresh; ++sym1__) {
        current_statement__ = 53;
        current_statement__ = 53;
        check_greater_or_equal(function__, "pa2[sym1__]", pa2[(sym1__ - 1)],
                               1);}
      current_statement__ = 53;
      for (int sym1__ = 1; sym1__ <= numRefresh; ++sym1__) {
        current_statement__ = 53;
        current_statement__ = 53;
        check_less_or_equal(function__, "pa2[sym1__]", pa2[(sym1__ - 1)], NPA);
      }
      current_statement__ = 54;
      validate_non_negative_index("weight", "NCMP", NCMP);
      current_statement__ = 55;
      context__.validate_dims("data initialization","weight","int",
          context__.to_vec(NCMP));
      weight = std::vector<int>(NCMP, std::numeric_limits<int>::min());
      
      current_statement__ = 55;
      assign(weight, nil_index_list(), context__.vals_i("weight"),
        "assigning variable weight");
      current_statement__ = 56;
      validate_non_negative_index("pick", "NCMP", NCMP);
      current_statement__ = 57;
      context__.validate_dims("data initialization","pick","int",
          context__.to_vec(NCMP));
      pick = std::vector<int>(NCMP, std::numeric_limits<int>::min());
      
      current_statement__ = 57;
      assign(pick, nil_index_list(), context__.vals_i("pick"),
        "assigning variable pick");
      current_statement__ = 58;
      validate_non_negative_index("refresh", "numRefresh", numRefresh);
      current_statement__ = 59;
      context__.validate_dims("data initialization","refresh","int",
          context__.to_vec(numRefresh));
      refresh = std::vector<int>(numRefresh, std::numeric_limits<int>::min());
      
      current_statement__ = 59;
      assign(refresh, nil_index_list(), context__.vals_i("refresh"),
        "assigning variable refresh");
      current_statement__ = 60;
      validate_non_negative_index("numOutcome", "numRefresh", numRefresh);
      current_statement__ = 61;
      context__.validate_dims("data initialization","numOutcome","int",
          context__.to_vec(numRefresh));
      numOutcome = std::vector<int>(numRefresh, std::numeric_limits<int>::min());
      
      current_statement__ = 61;
      assign(numOutcome, nil_index_list(), context__.vals_i("numOutcome"),
        "assigning variable numOutcome");
      current_statement__ = 62;
      validate_non_negative_index("item", "numRefresh", numRefresh);
      current_statement__ = 63;
      context__.validate_dims("data initialization","item","int",
          context__.to_vec(numRefresh));
      item = std::vector<int>(numRefresh, std::numeric_limits<int>::min());
      
      current_statement__ = 63;
      assign(item, nil_index_list(), context__.vals_i("item"),
        "assigning variable item");
      current_statement__ = 64;
      totalThresholds = std::numeric_limits<int>::min();
      
      current_statement__ = 64;
      totalThresholds = sum(NTHRESH);
      current_statement__ = 65;
      validate_non_negative_index("rcat", "NCMP", NCMP);
      current_statement__ = 66;
      rcat = std::vector<int>(NCMP, std::numeric_limits<int>::min());
      
      {
        int cmpStart;
        cmpStart = std::numeric_limits<int>::min();
        
        current_statement__ = 67;
        cmpStart = 0;
        current_statement__ = 74;
        for (int rx = 1; rx <= numRefresh; ++rx) {
          int ix;
          ix = std::numeric_limits<int>::min();
          
          current_statement__ = 68;
          ix = item[(rx - 1)];
          current_statement__ = 71;
          for (int cmp = 1; cmp <= refresh[(rx - 1)]; ++cmp) {
            current_statement__ = 69;
            assign(rcat,
              cons_list(index_uni((cmpStart + cmp)), nil_index_list()),
              ((pick[((cmpStart + cmp) - 1)] + NTHRESH[(ix - 1)]) + 1),
              "assigning variable rcat");}
          current_statement__ = 72;
          cmpStart = (cmpStart + refresh[(rx - 1)]);}
      }
      current_statement__ = 76;
      validate_non_negative_index("rawThreshold", "totalThresholds",
                                  totalThresholds);
      current_statement__ = 77;
      validate_non_negative_index("alpha", "NITEMS", NITEMS);
      current_statement__ = 78;
      validate_non_negative_index("rawTheta", "NPA", NPA);
      current_statement__ = 79;
      validate_non_negative_index("rawTheta", "NITEMS", NITEMS);
      current_statement__ = 80;
      validate_non_negative_index("rawThetaCorChol", "NITEMS", NITEMS);
      current_statement__ = 80;
      validate_non_negative_index("rawThetaCorChol", "NITEMS", NITEMS);
      current_statement__ = 81;
      validate_non_negative_index("threshold", "totalThresholds",
                                  totalThresholds);
      current_statement__ = 82;
      validate_non_negative_index("rawCumTh", "totalThresholds",
                                  totalThresholds);
      current_statement__ = 83;
      validate_non_negative_index("theta", "NPA", NPA);
      current_statement__ = 84;
      validate_non_negative_index("theta", "NITEMS", NITEMS);
      current_statement__ = 85;
      validate_non_negative_index("thetaCor", "NITEMS", NITEMS);
      current_statement__ = 85;
      validate_non_negative_index("thetaCor", "NITEMS", NITEMS);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += totalThresholds;
      num_params_r__ += NITEMS;
      num_params_r__ += NPA * NITEMS;
      num_params_r__ += ((NITEMS * (NITEMS - 1)) / 2);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_correlation_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> rawThreshold;
      rawThreshold = Eigen::Matrix<local_scalar_t__, -1, 1>(totalThresholds);
      stan::math::fill(rawThreshold, DUMMY_VAR__);
      
      current_statement__ = 1;
      rawThreshold = in__.vector(totalThresholds);
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
        current_statement__ = 1;
        if (jacobian__) {
          current_statement__ = 1;
          assign(rawThreshold,
            cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(rawThreshold[(sym1__ - 1)], 0, 1, lp__),
            "assigning variable rawThreshold");
        } else {
          current_statement__ = 1;
          assign(rawThreshold,
            cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(rawThreshold[(sym1__ - 1)], 0, 1),
            "assigning variable rawThreshold");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> alpha;
      alpha = Eigen::Matrix<local_scalar_t__, -1, 1>(NITEMS);
      stan::math::fill(alpha, DUMMY_VAR__);
      
      current_statement__ = 2;
      alpha = in__.vector(NITEMS);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        current_statement__ = 2;
        if (jacobian__) {
          current_statement__ = 2;
          assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(alpha[(sym1__ - 1)], 0, lp__),
            "assigning variable alpha");
        } else {
          current_statement__ = 2;
          assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(alpha[(sym1__ - 1)], 0),
            "assigning variable alpha");
        }}
      Eigen::Matrix<local_scalar_t__, -1, -1> rawTheta;
      rawTheta = Eigen::Matrix<local_scalar_t__, -1, -1>(NPA, NITEMS);
      stan::math::fill(rawTheta, DUMMY_VAR__);
      
      current_statement__ = 3;
      rawTheta = in__.matrix(NPA, NITEMS);
      Eigen::Matrix<local_scalar_t__, -1, -1> rawThetaCorChol;
      rawThetaCorChol = Eigen::Matrix<local_scalar_t__, -1, -1>(NITEMS, NITEMS);
      stan::math::fill(rawThetaCorChol, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> rawThetaCorChol_in__;
      rawThetaCorChol_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>(((NITEMS
                                                                    *
                                                                    (NITEMS -
                                                                    1)) / 2));
      stan::math::fill(rawThetaCorChol_in__, DUMMY_VAR__);
      
      current_statement__ = 4;
      rawThetaCorChol_in__ = in__.vector(((NITEMS * (NITEMS - 1)) / 2));
      current_statement__ = 4;
      if (jacobian__) {
        current_statement__ = 4;
        assign(rawThetaCorChol, nil_index_list(),
          stan::math::cholesky_corr_constrain(rawThetaCorChol_in__, NITEMS,
            lp__), "assigning variable rawThetaCorChol");
      } else {
        current_statement__ = 4;
        assign(rawThetaCorChol, nil_index_list(),
          stan::math::cholesky_corr_constrain(rawThetaCorChol_in__, NITEMS),
          "assigning variable rawThetaCorChol");
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> threshold;
      threshold = Eigen::Matrix<local_scalar_t__, -1, 1>(totalThresholds);
      stan::math::fill(threshold, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> rawCumTh;
      rawCumTh = Eigen::Matrix<local_scalar_t__, -1, 1>(totalThresholds);
      stan::math::fill(rawCumTh, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> theta;
      theta = Eigen::Matrix<local_scalar_t__, -1, -1>(NPA, NITEMS);
      stan::math::fill(theta, DUMMY_VAR__);
      
      current_statement__ = 10;
      for (int pa = 1; pa <= NPA; ++pa) {
        current_statement__ = 8;
        assign(theta,
          cons_list(index_uni(pa), cons_list(index_omni(), nil_index_list())),
          transpose(
            multiply(rawThetaCorChol,
              transpose(
                rvalue(rawTheta,
                  cons_list(index_uni(pa),
                    cons_list(index_omni(), nil_index_list())), "rawTheta")))),
          "assigning variable theta");}
      current_statement__ = 17;
      for (int ix = 1; ix <= NITEMS; ++ix) {
        local_scalar_t__ maxSpan;
        maxSpan = DUMMY_VAR__;
        
        current_statement__ = 11;
        maxSpan = (max(
                     rvalue(theta,
                       cons_list(index_omni(),
                         cons_list(index_uni(ix), nil_index_list())),
                       "theta")) -
                    min(
                      rvalue(theta,
                        cons_list(index_omni(),
                          cons_list(index_uni(ix), nil_index_list())),
                        "theta")));
        int from;
        from = std::numeric_limits<int>::min();
        
        current_statement__ = 12;
        from = TOFFSET[(ix - 1)];
        int to;
        to = std::numeric_limits<int>::min();
        
        current_statement__ = 13;
        to = ((TOFFSET[(ix - 1)] + NTHRESH[(ix - 1)]) - 1);
        current_statement__ = 14;
        assign(threshold,
          cons_list(index_min_max(from, to), nil_index_list()),
          multiply(maxSpan,
            rvalue(rawThreshold,
              cons_list(index_min_max(from, to), nil_index_list()),
              "rawThreshold")), "assigning variable threshold");
        current_statement__ = 15;
        assign(rawCumTh,
          cons_list(index_min_max(from, to), nil_index_list()),
          cumulative_sum(
            rvalue(threshold,
              cons_list(index_min_max(from, to), nil_index_list()),
              "threshold")), "assigning variable rawCumTh");}
      {
        current_statement__ = 20;
        lp_accum__.add(
          lkj_corr_cholesky_lpdf<propto__>(rawThetaCorChol, corLKJPrior));
        current_statement__ = 23;
        for (int pa = 1; pa <= NPA; ++pa) {
          current_statement__ = 21;
          lp_accum__.add(
            std_normal_lpdf<propto__>(
              rvalue(rawTheta,
                cons_list(index_uni(pa),
                  cons_list(index_omni(), nil_index_list())), "rawTheta")));}
        current_statement__ = 24;
        lp_accum__.add(beta_lpdf<propto__>(rawThreshold, 1.1, 2));
        current_statement__ = 27;
        for (int ix = 1; ix <= NITEMS; ++ix) {
          current_statement__ = 25;
          if (logical_lt(alpha[(ix - 1)], 0)) {
            current_statement__ = 25;
            lp_accum__.add(stan::math::negative_infinity());
          } else {
            current_statement__ = 25;
            lp_accum__.add(-normal_ccdf_log(0, 1.749, alphaScalePrior));
          }
          current_statement__ = 26;
          lp_accum__.add(
            normal_lpdf<propto__>(alpha[(ix - 1)], 1.749, alphaScalePrior));}
        {
          int cmpStart;
          cmpStart = std::numeric_limits<int>::min();
          
          current_statement__ = 28;
          cmpStart = 1;
          current_statement__ = 35;
          for (int rx = 1; rx <= numRefresh; ++rx) {
            int ix;
            ix = std::numeric_limits<int>::min();
            
            current_statement__ = 29;
            ix = item[(rx - 1)];
            int from;
            from = std::numeric_limits<int>::min();
            
            current_statement__ = 30;
            from = TOFFSET[(ix - 1)];
            int to;
            to = std::numeric_limits<int>::min();
            
            current_statement__ = 31;
            to = ((TOFFSET[(ix - 1)] + NTHRESH[(ix - 1)]) - 1);
            current_statement__ = 32;
            lp_accum__.add(
              pairwise_logprob(rcat, weight, cmpStart, refresh[(rx - 1)],
                scale[(ix - 1)], alpha[(ix - 1)],
                rvalue(theta,
                  cons_list(index_uni(pa1[(rx - 1)]),
                    cons_list(index_uni(ix), nil_index_list())), "theta"),
                rvalue(theta,
                  cons_list(index_uni(pa2[(rx - 1)]),
                    cons_list(index_uni(ix), nil_index_list())), "theta"),
                rvalue(rawCumTh,
                  cons_list(index_min_max(from, to), nil_index_list()),
                  "rawCumTh"), pstream__));
            current_statement__ = 33;
            cmpStart = (cmpStart + refresh[(rx - 1)]);}
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_correlation_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> rawThreshold;
      rawThreshold = Eigen::Matrix<double, -1, 1>(totalThresholds);
      stan::math::fill(rawThreshold, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      rawThreshold = in__.vector(totalThresholds);
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
        current_statement__ = 1;
        assign(rawThreshold, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_constrain(rawThreshold[(sym1__ - 1)], 0, 1),
          "assigning variable rawThreshold");}
      Eigen::Matrix<double, -1, 1> alpha;
      alpha = Eigen::Matrix<double, -1, 1>(NITEMS);
      stan::math::fill(alpha, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      alpha = in__.vector(NITEMS);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        current_statement__ = 2;
        assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(alpha[(sym1__ - 1)], 0),
          "assigning variable alpha");}
      Eigen::Matrix<double, -1, -1> rawTheta;
      rawTheta = Eigen::Matrix<double, -1, -1>(NPA, NITEMS);
      stan::math::fill(rawTheta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      rawTheta = in__.matrix(NPA, NITEMS);
      Eigen::Matrix<double, -1, -1> rawThetaCorChol;
      rawThetaCorChol = Eigen::Matrix<double, -1, -1>(NITEMS, NITEMS);
      stan::math::fill(rawThetaCorChol, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<local_scalar_t__, -1, 1> rawThetaCorChol_in__;
      rawThetaCorChol_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>(((NITEMS
                                                                    *
                                                                    (NITEMS -
                                                                    1)) / 2));
      stan::math::fill(rawThetaCorChol_in__, DUMMY_VAR__);
      
      current_statement__ = 4;
      rawThetaCorChol_in__ = in__.vector(((NITEMS * (NITEMS - 1)) / 2));
      current_statement__ = 4;
      assign(rawThetaCorChol, nil_index_list(),
        stan::math::cholesky_corr_constrain(rawThetaCorChol_in__, NITEMS),
        "assigning variable rawThetaCorChol");
      Eigen::Matrix<double, -1, 1> threshold;
      threshold = Eigen::Matrix<double, -1, 1>(totalThresholds);
      stan::math::fill(threshold, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> rawCumTh;
      rawCumTh = Eigen::Matrix<double, -1, 1>(totalThresholds);
      stan::math::fill(rawCumTh, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> theta;
      theta = Eigen::Matrix<double, -1, -1>(NPA, NITEMS);
      stan::math::fill(theta, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
        vars__.emplace_back(rawThreshold[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        vars__.emplace_back(alpha[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
          vars__.emplace_back(
            rvalue(rawTheta,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "rawTheta"));
        }}
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NITEMS; ++sym2__) {
          vars__.emplace_back(
            rvalue(rawThetaCorChol,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              "rawThetaCorChol"));}}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 10;
      for (int pa = 1; pa <= NPA; ++pa) {
        current_statement__ = 8;
        assign(theta,
          cons_list(index_uni(pa), cons_list(index_omni(), nil_index_list())),
          transpose(
            multiply(rawThetaCorChol,
              transpose(
                rvalue(rawTheta,
                  cons_list(index_uni(pa),
                    cons_list(index_omni(), nil_index_list())), "rawTheta")))),
          "assigning variable theta");}
      current_statement__ = 17;
      for (int ix = 1; ix <= NITEMS; ++ix) {
        double maxSpan;
        maxSpan = std::numeric_limits<double>::quiet_NaN();
        
        current_statement__ = 11;
        maxSpan = (max(
                     rvalue(theta,
                       cons_list(index_omni(),
                         cons_list(index_uni(ix), nil_index_list())),
                       "theta")) -
                    min(
                      rvalue(theta,
                        cons_list(index_omni(),
                          cons_list(index_uni(ix), nil_index_list())),
                        "theta")));
        int from;
        from = std::numeric_limits<int>::min();
        
        current_statement__ = 12;
        from = TOFFSET[(ix - 1)];
        int to;
        to = std::numeric_limits<int>::min();
        
        current_statement__ = 13;
        to = ((TOFFSET[(ix - 1)] + NTHRESH[(ix - 1)]) - 1);
        current_statement__ = 14;
        assign(threshold,
          cons_list(index_min_max(from, to), nil_index_list()),
          multiply(maxSpan,
            rvalue(rawThreshold,
              cons_list(index_min_max(from, to), nil_index_list()),
              "rawThreshold")), "assigning variable threshold");
        current_statement__ = 15;
        assign(rawCumTh,
          cons_list(index_min_max(from, to), nil_index_list()),
          cumulative_sum(
            rvalue(threshold,
              cons_list(index_min_max(from, to), nil_index_list()),
              "threshold")), "assigning variable rawCumTh");}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
          vars__.emplace_back(threshold[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
          vars__.emplace_back(rawCumTh[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
            vars__.emplace_back(
              rvalue(theta,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "theta"));
          }}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, -1> thetaCor;
      thetaCor = Eigen::Matrix<double, -1, -1>(NITEMS, NITEMS);
      stan::math::fill(thetaCor, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 19;
      assign(thetaCor, nil_index_list(),
        multiply_lower_tri_self_transpose(rawThetaCorChol),
        "assigning variable thetaCor");
      current_statement__ = 18;
      current_statement__ = 18;
      check_corr_matrix(function__, "thetaCor", thetaCor);
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NITEMS; ++sym2__) {
          vars__.emplace_back(
            rvalue(thetaCor,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "thetaCor"));
        }}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> rawThreshold;
      rawThreshold = Eigen::Matrix<double, -1, 1>(totalThresholds);
      stan::math::fill(rawThreshold, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> rawThreshold_flat__;
        current_statement__ = 1;
        assign(rawThreshold_flat__, nil_index_list(),
          context__.vals_r("rawThreshold"),
          "assigning variable rawThreshold_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
          current_statement__ = 1;
          assign(rawThreshold,
            cons_list(index_uni(sym1__), nil_index_list()),
            rawThreshold_flat__[(pos__ - 1)],
            "assigning variable rawThreshold");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> rawThreshold_free__;
      rawThreshold_free__ = Eigen::Matrix<double, -1, 1>(totalThresholds);
      stan::math::fill(rawThreshold_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
        current_statement__ = 1;
        assign(rawThreshold_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_free(rawThreshold[(sym1__ - 1)], 0, 1),
          "assigning variable rawThreshold_free__");}
      Eigen::Matrix<double, -1, 1> alpha;
      alpha = Eigen::Matrix<double, -1, 1>(NITEMS);
      stan::math::fill(alpha, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> alpha_flat__;
        current_statement__ = 2;
        assign(alpha_flat__, nil_index_list(), context__.vals_r("alpha"),
          "assigning variable alpha_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
          current_statement__ = 2;
          assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
            alpha_flat__[(pos__ - 1)], "assigning variable alpha");
          current_statement__ = 2;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> alpha_free__;
      alpha_free__ = Eigen::Matrix<double, -1, 1>(NITEMS);
      stan::math::fill(alpha_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        current_statement__ = 2;
        assign(alpha_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(alpha[(sym1__ - 1)], 0),
          "assigning variable alpha_free__");}
      Eigen::Matrix<double, -1, -1> rawTheta;
      rawTheta = Eigen::Matrix<double, -1, -1>(NPA, NITEMS);
      stan::math::fill(rawTheta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> rawTheta_flat__;
        current_statement__ = 3;
        assign(rawTheta_flat__, nil_index_list(),
          context__.vals_r("rawTheta"), "assigning variable rawTheta_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
            current_statement__ = 3;
            assign(rawTheta,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              rawTheta_flat__[(pos__ - 1)], "assigning variable rawTheta");
            current_statement__ = 3;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, -1> rawThetaCorChol;
      rawThetaCorChol = Eigen::Matrix<double, -1, -1>(NITEMS, NITEMS);
      stan::math::fill(rawThetaCorChol, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> rawThetaCorChol_flat__;
        current_statement__ = 4;
        assign(rawThetaCorChol_flat__, nil_index_list(),
          context__.vals_r("rawThetaCorChol"),
          "assigning variable rawThetaCorChol_flat__");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
          current_statement__ = 4;
          for (int sym2__ = 1; sym2__ <= NITEMS; ++sym2__) {
            current_statement__ = 4;
            assign(rawThetaCorChol,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              rawThetaCorChol_flat__[(pos__ - 1)],
              "assigning variable rawThetaCorChol");
            current_statement__ = 4;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, 1> rawThetaCorChol_free__;
      rawThetaCorChol_free__ = Eigen::Matrix<double, -1, 1>(((NITEMS *
                                                               (NITEMS - 1))
                                                              / 2));
      stan::math::fill(rawThetaCorChol_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      assign(rawThetaCorChol_free__, nil_index_list(),
        stan::math::cholesky_corr_free(rawThetaCorChol),
        "assigning variable rawThetaCorChol_free__");
      for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
        vars__.emplace_back(rawThreshold_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        vars__.emplace_back(alpha_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
          vars__.emplace_back(
            rvalue(rawTheta,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "rawTheta"));
        }}
      for (int sym1__ = 1; sym1__ <= ((NITEMS * (NITEMS - 1)) / 2); ++sym1__) {
        vars__.emplace_back(rawThetaCorChol_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("rawThreshold");
    names__.emplace_back("alpha");
    names__.emplace_back("rawTheta");
    names__.emplace_back("rawThetaCorChol");
    names__.emplace_back("threshold");
    names__.emplace_back("rawCumTh");
    names__.emplace_back("theta");
    names__.emplace_back("thetaCor");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(totalThresholds)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NITEMS)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NPA),
                                             static_cast<size_t>(NITEMS)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NITEMS),
                                             static_cast<size_t>(NITEMS)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(totalThresholds)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(totalThresholds)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NPA),
                                             static_cast<size_t>(NITEMS)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NITEMS),
                                             static_cast<size_t>(NITEMS)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "rawThreshold" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "rawTheta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= NITEMS; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "rawThetaCorChol" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "threshold" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "rawCumTh" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NITEMS; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "thetaCor" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "rawThreshold" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "rawTheta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= ((NITEMS * (NITEMS - 1)) / 2); ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "rawThetaCorChol" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "threshold" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= totalThresholds; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "rawCumTh" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= NITEMS; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NPA; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= ((NITEMS * (NITEMS - 1)) / 2); ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "thetaCor" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"rawThreshold\",\"type\":{\"name\":\"vector\",\"length\":" << totalThresholds << "},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" << NITEMS << "},\"block\":\"parameters\"},{\"name\":\"rawTheta\",\"type\":{\"name\":\"matrix\",\"rows\":" << NPA << ",\"cols\":" << NITEMS << "},\"block\":\"parameters\"},{\"name\":\"rawThetaCorChol\",\"type\":{\"name\":\"matrix\",\"rows\":" << NITEMS << ",\"cols\":" << NITEMS << "},\"block\":\"parameters\"},{\"name\":\"threshold\",\"type\":{\"name\":\"vector\",\"length\":" << totalThresholds << "},\"block\":\"transformed_parameters\"},{\"name\":\"rawCumTh\",\"type\":{\"name\":\"vector\",\"length\":" << totalThresholds << "},\"block\":\"transformed_parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"matrix\",\"rows\":" << NPA << ",\"cols\":" << NITEMS << "},\"block\":\"transformed_parameters\"},{\"name\":\"thetaCor\",\"type\":{\"name\":\"matrix\",\"rows\":" << NITEMS << ",\"cols\":" << NITEMS << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"rawThreshold\",\"type\":{\"name\":\"vector\",\"length\":" << totalThresholds << "},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" << NITEMS << "},\"block\":\"parameters\"},{\"name\":\"rawTheta\",\"type\":{\"name\":\"matrix\",\"rows\":" << NPA << ",\"cols\":" << NITEMS << "},\"block\":\"parameters\"},{\"name\":\"rawThetaCorChol\",\"type\":{\"name\":\"vector\",\"length\":" << ((NITEMS * (NITEMS - 1)) / 2) << "},\"block\":\"parameters\"},{\"name\":\"threshold\",\"type\":{\"name\":\"vector\",\"length\":" << totalThresholds << "},\"block\":\"transformed_parameters\"},{\"name\":\"rawCumTh\",\"type\":{\"name\":\"vector\",\"length\":" << totalThresholds << "},\"block\":\"transformed_parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"matrix\",\"rows\":" << NPA << ",\"cols\":" << NITEMS << "},\"block\":\"transformed_parameters\"},{\"name\":\"thetaCor\",\"type\":{\"name\":\"vector\",\"length\":" << ((NITEMS * (NITEMS - 1)) / 2) << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_correlation_namespace::model_correlation;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_correlation_namespace::profiles__;
}
#endif
#endif
