# Library and Minification

By default webpack will minify and optimise the code a great deal.

Take the following piece of JavaScript code for instance.

```js
// global variable
let number = 41;

// my hello function
function hello(myVariable){
    let total = number + myVariable;
    console.log(total);
}
```

By default webpack will minify it; removing
whitespaces, comments, even _renaming variables._ 
This is great because it minimises file size a great deal.

```js
let n=41;function h(e){let l=n+e;console.log(l)}
```

However, what if we want to export this JavaScript code
so others can use it directly.
Other users won't be able to call the `hello` function,
it has been simplified to something unknown.

In order to preserve this we have to tell webpack we are
building a library.

Packer lets you do this with a single function.

```r
packer::make_library()
```

This will preserve the function names and make them available
at the library name provided, e.g.: 
`packer::make_library("myLib")`

```js
myLib.hello();
```

By default the library name added by `packer::make_library` is 
dynamically assigned: it is the same as the name of the name
of the scaffold. e.g.: `scaffold_input("switch")` then running
`make_library()` will produce a library named `switch`.

This is great if you have multiple "scaffolds" within a single package. An absolute name will make it such that every library
generated by a scaffold (bundles are built sequentially) is
overwritten by the next. You would technically be creating
multiple libraries all with the same name. Think of R,
package names must be unique, same here.

This is useful if you have an R function that generates JavaScript
code.

```r
fooForShinyUI <- function(var){
	shiny::tags$script(
		sprintf("myLib.hello(%s)", var)
	)
}
```
