% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrateIntensity_exp.R
\name{integrateIntensity_exp}
\alias{integrateIntensity_exp}
\title{Integrate the multivariate exponential intensity}
\usage{
integrateIntensity_exp(
  lowerCoords,
  upperCoords,
  s,
  baseIntensities,
  lambda,
  numWindows
)
}
\arguments{
\item{lowerCoords, upperCoords}{Matrices of lower and upper x- and y-coordinates of a set of windows. One row for each window.}

\item{s}{Vector of x- and y-coordinates of the AC location.}

\item{baseIntensities}{Vector of baseline intensities for all windows.}

\item{lambda}{Rate parameter of the isotropic multivariate exponential distribution.}

\item{numWindows}{Total number of windows. This value (positive integer) is used to truncate \code{lowerCoords} and \code{upperCoords} 
so that extra rows beyond \code{numWindows} are ignored.}
}
\value{
A vector of integrated intensities over all windows.
}
\description{
Calculate the integral of the intensity function with an isotropic multivariate exponential
kernel over a set of windows.
}
\examples{
lowerCoords <- matrix(c(0, 0, 1, 0, 0, 1, 1, 1), nrow = 4, byrow = TRUE)
upperCoords <- matrix(c(1, 1, 2, 1, 1, 2, 2, 2), nrow = 4, byrow = TRUE)
s <- c(1, 1)
lambda <- 1.0
baseIntensities <- c(1:4)
numWindows <- 4
integrateIntensity_exp(lowerCoords, upperCoords, s, baseIntensities, lambda, numWindows)

}
\references{
W. Zhang, J. D. Chipperfield, J. B. Illian, P. Dupont, C. Milleret, P. de Valpine and R. Bischof. 2020. 
A hierarchical point process model for spatial capture-recapture data. bioRxiv. DOI 10.1101/2020.10.06.325035
}
\author{
Wei Zhang
}
