% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{ranger_filter}
\alias{ranger_filter}
\title{Random forest ranger filter}
\usage{
ranger_filter(
  y,
  x,
  nfilter = NULL,
  type = c("index", "names", "full"),
  num.trees = 1000,
  mtry = ncol(x) * 0.2,
  ...
)
}
\arguments{
\item{y}{Response vector}

\item{x}{Matrix of predictors}

\item{nfilter}{Number of predictors to return. If \code{NULL} all predictors are
returned.}

\item{type}{Type of vector returned. Default "index" returns indices,
"names" returns predictor names, "full" returns a named vector of variable
importance.}

\item{num.trees}{Number of trees to grow. See \link[ranger:ranger]{ranger::ranger}.}

\item{mtry}{Number of predictors randomly sampled as candidates at each
split. See \link[ranger:ranger]{ranger::ranger}.}

\item{...}{Optional arguments passed to \link[ranger:ranger]{ranger::ranger}.}
}
\value{
Integer vector of indices of filtered parameters (type = "index") or
character vector of names (type = "names") of filtered parameters. If
\code{type} is \code{"full"} a named vector of variable importance is returned.
}
\description{
Fits a random forest model via the \code{ranger} package and ranks variables by
variable importance.
}
\details{
This filter uses the \code{ranger()} function from the \code{ranger} package. Variable
importance is calculated using mean decrease in gini impurity.
}
