% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linprog.R
\name{linprog}
\alias{linprog}
\title{MatLab(R)-style Linear Programming in R using ROI}
\usage{
linprog(f, A = NULL, b = NULL, Aeq = NULL, beq = NULL, lb = NULL,
  ub = NULL, x0 = NULL, options = NULL)
}
\arguments{
\item{f}{Linear term (vector) of the objective function}

\item{A}{Inequality constraints (left-hand side)}

\item{b}{Inequality constraints (right-hand side)}

\item{Aeq}{Equality constraints (left-hand side)}

\item{beq}{Equality constraints (right-hand side)}

\item{lb}{Lower bound}

\item{ub}{Upper bound}

\item{x0}{Initial solution}

\item{options}{Additional optimization parameters}
}
\value{
The solution vector in \code{x} as well as the objective value
in \code{fval}.
}
\description{
\code{linprog} provides a simple interface to ROI using the optimization
model specification of MatLab(R)

minimize in x: f'*x
subject to: A*x <= b 
subject to: Aeq*x == beq
x >= lb
x <= ub
}
\examples{
# maximize: 2x1 + x2
# subject to: 
#   x1 + x2 <= 5
#   x1 <= 3
#   x1 >= 0, x2 >= 0

f <- c(2, 1)
A <- matrix(c(1, 1, 1, 0), nrow=2, byrow=TRUE)
b <- c(5, 3)

sol <- linprog(-f, A, b)
sol$x

}
\author{
Ronald Hochreiter, \email{ron@hochreiter.net}
}
