% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimator.R
\docType{data}
\name{mlapiEstimationOnline}
\alias{mlapiEstimationOnline}
\title{Base abstract class for all classification/regression models
which can be \bold{trained incremendally} (online)}
\format{\code{R6Class} object.}
\usage{
mlapiEstimationOnline
}
\description{
Base class for all online estimators. This class inherits from \link{mlapiEstimation} and
additionally requires to implement \code{$partial_fit(x, y, ...)} method. Idea is that user can pass
\code{x, y} in chunks and model will be updated/refined incrementally.
}
\section{Methods}{

\describe{
  \item{\code{$fit(x, y, ...)}}{}
  \item{\code{$partial_fit(x, y, ...)}}{}
  \item{\code{$predict(x, ...)}}{Makes predictions on new data (after model was trained)}
}
}

\section{Arguments}{

\describe{
 \item{x}{A matrix like object, should \bold{inherit from \code{Matrix} or \code{matrix}}.
 Allowed classes should be defined in child classes.}
 \item{y}{target - usually \code{vector}, but also can be a matrix like object.
 Allowed classes should be defined in child classes.}
 \item{...}{additional parameters \bold{with default values}}
}
}

\keyword{datasets}
