% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anyMissing.R
\name{anyMissing}
\alias{anyMissing}
\alias{colAnyMissings}
\alias{rowAnyMissings}
\alias{colAnyNAs}
\alias{rowAnyNAs}
\title{Checks if there are any missing values in an object or not}
\usage{
anyMissing(x, idxs = NULL, ...)

colAnyMissings(x, rows = NULL, cols = NULL, ..., useNames = TRUE)

rowAnyMissings(x, rows = NULL, cols = NULL, ..., useNames = TRUE)

colAnyNAs(x, rows = NULL, cols = NULL, ..., useNames = TRUE)

rowAnyNAs(x, rows = NULL, cols = NULL, ..., useNames = TRUE)
}
\arguments{
\item{x}{A \code{\link[base]{vector}}, a \code{\link[base]{list}}, a
\code{\link[base]{matrix}}, a \code{\link[base]{data.frame}}, or
\code{\link[base]{NULL}}.}

\item{idxs}{A \code{\link[base]{vector}} indicating subset of elements to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{...}{Not used.}

\item{rows}{A \code{\link[base]{vector}} indicating subset of rows to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{cols}{A \code{\link[base]{vector}} indicating subset of columns to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{useNames}{If \code{\link[base:logical]{TRUE}} (default), names
attributes of the result are set, otherwise not.}
}
\value{
Returns \code{\link[base:logical]{TRUE}} if a missing value was
detected, otherwise \code{\link[base:logical]{FALSE}}.
}
\description{
Checks if there are any missing values in an object or not.
\emph{Please use \code{base::anyNA()} instead of \code{anyMissing()},
\code{colAnyNAs()} instead of \code{colAnyMissings()}, and
\code{rowAnyNAs()} instead of \code{rowAnyMissings()}.}
}
\details{
The implementation of this method is optimized for both speed and memory.
The method will return \code{\link[base:logical]{TRUE}} as soon as a missing
value is detected.
}
\examples{
 x <- rnorm(n = 1000)
 x[seq(300, length(x), by = 100)] <- NA
 stopifnot(anyMissing(x) == any(is.na(x)))

}
\seealso{
Starting with R v3.1.0, there is \code{anyNA()} in the \pkg{base},
which provides the same functionality as \code{anyMissing()}.
}
\author{
Henrik Bengtsson
}
\keyword{iteration}
\keyword{logic}
