% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regvec3d.R
\name{plot.regvec3d}
\alias{plot.regvec3d}
\alias{summary.regvec3d}
\alias{print.regvec3d}
\title{Plot method for regvec3d objects}
\usage{
\method{plot}{regvec3d}(
  x,
  y,
  dimension = 3,
  col = c("black", "red", "blue", "brown", "lightgray"),
  col.plane = "gray",
  cex.lab = 1.2,
  show.base = 2,
  show.marginal = FALSE,
  show.hplane = TRUE,
  show.angles = TRUE,
  error.sphere = c("none", "e", "y.hat"),
  scale.error.sphere = x$scale,
  level.error.sphere = 0.95,
  grid = FALSE,
  add = FALSE,
  ...
)

\method{summary}{regvec3d}(object, ...)

\method{print}{regvec3d}(x, ...)
}
\arguments{
\item{x}{A \dQuote{regvec3d} object}

\item{y}{Ignored; only included for compatibility with the S3 generic}

\item{dimension}{Number of dimensions to plot: \code{3} (default) or \code{2}}

\item{col}{A vector of 5 colors. \code{col[1]} is used for the y and residual (e) vectors, and for x1 and x2;
\code{col[2]} is used for the vectors \code{y -> yhat} and \code{y -> e};
\code{col[3]} is used for the vectors \code{yhat -> b1} and \code{yhat -> b2};}

\item{col.plane}{Color of the base plane in a 3D plot or axes in a 2D plot}

\item{cex.lab}{character expansion applied to vector labels. May be a number or numeric vector corresponding to the the
rows of \code{X}, recycled as necessary.}

\item{show.base}{If \code{show.base > 0}, draws the base plane in a 3D plot; if \code{show.base > 1},
the plane is drawn thicker}

\item{show.marginal}{If \code{TRUE} also draws lines showing the marginal relations of \code{y} on \code{x1} and on \code{x2}}

\item{show.hplane}{If \code{TRUE}, draws the plane defined by \code{y}, \code{yhat} and the origin in the 3D}

\item{show.angles}{If \code{TRUE}, draw and label the angle between the \code{x1} and \code{x2} and between \code{y} and \code{yhat},
corresponding respectively to the correlation between the xs and the multiple correlation}

\item{error.sphere}{Plot a sphere (or in 2D, a circle) of radius proportional to the length of
the residual vector, centered either at the origin (\code{"e"})
or at the fitted-values vector (\code{"y.hat"}; the default is \code{"none"}.)}

\item{scale.error.sphere}{Whether to scale the error sphere if \code{error.sphere="y.hat"}; defaults to \code{TRUE} if the
vectors representing the variables are scaled, in which case the oblique projections of the error spheres
can represent confidence intervals for the coefficients; otherwise defaults to \code{FALSE}.}

\item{level.error.sphere}{The confidence level for the error sphere, applied if \code{scale.error.sphere=TRUE}.}

\item{grid}{If \code{TRUE}, draws a light grid on the base plane}

\item{add}{If \code{TRUE}, add to the current plot; otherwise start a new rgl or plot window}

\item{...}{Parameters passed down to functions [unused now]}

\item{object}{A \code{regvec3d} object for the \code{summary} method}
}
\value{
None
}
\description{
The plot method for \code{regvec3d} objects uses the low-level graphics tools in this package to draw 3D and 3D
vector diagrams reflecting the partial and marginal
relations of \code{y} to \code{x1} and \code{x2} in a bivariate multiple linear regression model,
\code{lm(y ~ x1 + x2)}.

The \code{summary} method prints the vectors and their vector lengths, followed by the \code{summary}
for the model.
}
\details{
A 3D diagram shows the vector \code{y} and the plane formed by the predictors,
\code{x1} and \code{x2}, where all variables are represented in deviation form, so that
the intercept need not be included.

A 2D diagram, using the first two columns of the result, can be used to show the projection
of the space in the \code{x1}, \code{x2} plane.

The drawing functions \code{\link{vectors}} and \code{link{vectors3d}} used by the \code{\link{plot.regvec3d}} method only work
reasonably well if the variables are shown on commensurate scales, i.e., with
either \code{scale=TRUE} or \code{normalize=TRUE}.
}
\examples{
if (require(carData)) {
   data("Duncan", package="carData")
   dunc.reg <- regvec3d(prestige ~ income + education, data=Duncan)
   plot(dunc.reg)
   plot(dunc.reg, dimension=2)
   plot(dunc.reg, error.sphere="e")
   summary(dunc.reg)

   # Example showing Simpson's paradox
   data("States", package="carData")
   states.vec <- regvec3d(SATM ~ pay + percent, data=States, scale=TRUE)
   plot(states.vec, show.marginal=TRUE)
   plot(states.vec, show.marginal=TRUE, dimension=2)
   summary(states.vec)
}
}
\references{
Fox, J. (2016). \emph{Applied Regression Analysis and Generalized Linear Models}, 3rd ed., Sage, Chapter 10.
}
\seealso{
\code{\link{regvec3d}}, \code{\link{vectors3d}}, \code{\link{vectors}}

Other vector diagrams: 
\code{\link{Proj}()},
\code{\link{arc}()},
\code{\link{arrows3d}()},
\code{\link{circle3d}()},
\code{\link{corner}()},
\code{\link{pointOnLine}()},
\code{\link{regvec3d}()},
\code{\link{vectors}()},
\code{\link{vectors3d}()}
}
\concept{vector diagrams}
