% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian-elimination.R
\name{gaussianElimination}
\alias{gaussianElimination}
\alias{print.enhancedMatrix}
\title{Gaussian Elimination}
\usage{
gaussianElimination(
  A,
  B,
  tol = sqrt(.Machine$double.eps),
  verbose = FALSE,
  latex = FALSE,
  fractions = FALSE
)

\method{print}{enhancedMatrix}(x, ...)
}
\arguments{
\item{A}{coefficient matrix}

\item{B}{right-hand side vector or matrix. If \code{B} is a matrix, the result gives solutions for each column as the right-hand
side of the equations with coefficients in \code{A}.}

\item{tol}{tolerance for checking for 0 pivot}

\item{verbose}{logical; if \code{TRUE}, print intermediate steps}

\item{latex}{logical; if \code{TRUE}, and verbose is \code{TRUE}, print intermediate steps using LaTeX
equation outputs rather than R output}

\item{fractions}{logical; if \code{TRUE}, try to express non-integers as rational numbers, using the \code{\link[MASS]{fractions}}
function; if you require greater accuracy, you can set the \code{cycles} (default 10)
and/or \code{max.denominator} (default 2000) arguments to \code{fractions} as a global option, e.g.,
\code{options(fractions=list(cycles=100, max.denominator=10^4))}.}

\item{x}{matrix to print}

\item{...}{arguments to pass down}
}
\value{
If \code{B} is absent, returns the reduced row-echelon form of \code{A}.
        If \code{B} is present, returns the reduced row-echelon form of \code{A}, with the
        same operations applied to \code{B}.
}
\description{
\code{gaussianElimination} demonstrates the algorithm of row reduction used for solving
systems of linear equations of the form \eqn{A x = B}. Optional arguments \code{verbose}
and \code{fractions} may be used to see how the algorithm works.
}
\examples{
  A <- matrix(c(2, 1, -1,
               -3, -1, 2,
               -2,  1, 2), 3, 3, byrow=TRUE)
  b <- c(8, -11, -3)
  gaussianElimination(A, b)
  gaussianElimination(A, b, verbose=TRUE, fractions=TRUE)
  gaussianElimination(A, b, verbose=TRUE, fractions=TRUE, latex=TRUE)

  # determine whether matrix is solvable
  gaussianElimination(A, numeric(3))

  # find inverse matrix by elimination: A = I -> A^-1 A = A^-1 I -> I = A^-1
  gaussianElimination(A, diag(3))
  inv(A)

  # works for 1-row systems (issue # 30)
  A2 <- matrix(c(1, 1), nrow=1)
  b2 = 2
  gaussianElimination(A2, b2)
  showEqn(A2, b2)
  # plotEqn works for this case
  plotEqn(A2, b2)

}
\author{
John Fox
}
