% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignMeans.R
\name{getDesignMeanDiffMMRM}
\alias{getDesignMeanDiffMMRM}
\title{Power and sample size for two-sample mean difference
at the last time point from the MMRM model}
\usage{
getDesignMeanDiffMMRM(
  beta = NA_real_,
  n = NA_real_,
  meanDiffH0 = 0,
  meanDiff = 0.5,
  k = 1,
  covar1 = diag(k),
  covar2 = NA_real_,
  cumdrop1 = rep(0, k),
  cumdrop2 = NA_real_,
  allocationRatioPlanned = 1,
  normalApproximation = FALSE,
  rounding = TRUE,
  alpha = 0.025
)
}
\arguments{
\item{beta}{The type II error.}

\item{n}{The total sample size.}

\item{meanDiffH0}{The mean difference at the last time point
under the null hypothesis. Defaults to 0.}

\item{meanDiff}{The mean difference at the last time point
under the alternative hypothesis.}

\item{k}{The number of postbaseline time points.}

\item{covar1}{The covariance matrix for the repeated measures
given baseline for the active treatment group.}

\item{covar2}{The covariance matrix for the repeated measures
given baseline for the control group. If missing, it will be
set equal to the covariance matrix for the active treatment group.}

\item{cumdrop1}{The cumulative dropout rate at the postbaseline
time points for the active treatment group.}

\item{cumdrop2}{The cumulative dropout rate at the postbaseline
time points for the control group. If missing, it will be set
equal to the cumulative dropout rate for the active treatment group.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{normalApproximation}{The type of computation of the p-values.
If \code{TRUE}, the variance is assumed to be known, otherwise
the calculations are performed with the t distribution. The
degrees of freedom for the t-distribution is the total effective
sample size minus 2.}

\item{rounding}{Whether to round up sample size. Defaults to 1 for
sample size rounding.}

\item{alpha}{The one-sided significance level. Defaults to 0.025.}
}
\value{
An S3 class \code{designMeanDiffMMRM} object with the
following components:
\itemize{
\item \code{power}: The power to reject the null hypothesis.
\item \code{alpha}: The one-sided significance level.
\item \code{numberOfSubjects}: The maximum number of subjects.
\item \code{meanDiffH0}: The mean difference under the null hypothesis.
\item \code{meanDiff}: The mean difference under the alternative
hypothesis.
\item \code{k}: The number of postbaseline time points.
\item \code{covar1}: The covariance matrix for the repeated measures
given baseline for the active treatment group.
\item \code{covar2}: The covariance matrix for the repeated measures
given baseline for the control group.
\item \code{cumdrop1}: The cumulative dropout rate at the postbaseline
time points for the active treatment group.
\item \code{cumdrop2}: The cumulative dropout rate at the postbaseline
time points for the control group.
\item \code{inflation1}: The variance inflation factor for the active
treatment group.
\item \code{inflation2}: The variance inflation factor for the
control group.
\item \code{calculationTarget}: The calculation target, \code{beta} or
\code{n}.
\item \code{allocationRatioPlanned}: Allocation ratio for the active
treatment versus control.
\item \code{normalApproximation}: The type of computation of the p-values.
If \code{TRUE}, the variance is assumed to be known, otherwise
the calculations are performed with the t distribution.
\item \code{rounding}: Whether to round up sample size.
}
}
\description{
Obtains the power and sample size for two-sample
mean difference at the last time point from the mixed-model
for repeated measures (MMRM) model.
}
\examples{

# function to generate the AR(1) correlation matrix
ar1_cor <- function(n, corr) {
  exponent <- abs(matrix(1:n - 1, n, n, byrow = TRUE) - (1:n - 1))
  corr^exponent
}

# function to generate the cumulative dropout rate
exp_drop <- function(n, dropprob) {
  1 - (1 - dropprob)^((1:n)/n)
}

(design1 <- getDesignMeanDiffMMRM(
  beta = 0.2,
  n = NA_real_,
  meanDiffH0 = 0,
  meanDiff = 0.5,
  k = 4,
  covar1 = ar1_cor(4, 0.7),
  cumdrop1 = exp_drop(4, 0.10),
  allocationRatioPlanned = 1,
  normalApproximation = FALSE,
  rounding = TRUE,
  alpha = 0.025))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
