% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{samplesizeOnePropExact}
\alias{samplesizeOnePropExact}
\title{Sample Size for Binomial One-Sample Exact Test}
\usage{
samplesizeOnePropExact(
  beta = 0.2,
  piH0 = NA_real_,
  pi = NA_real_,
  alpha = 0.025
)
}
\arguments{
\item{beta}{The type II error.}

\item{piH0}{The response probability under the null hypothesis.}

\item{pi}{The response probability under the alternative hypothesis.}

\item{alpha}{The one-sided significance level. Defaults to 0.025.}
}
\value{
A data frame containing the critical value of the number of
responses for rejecting the null hypothesis, the attained type I
error, the power for the exact test, the sample size, the
response probabilities under the null and alternative hypotheses,
and the direction of the alternative.
}
\description{
Obtains the sample size for binomial one-sample exact test.
}
\examples{
samplesizeOnePropExact(beta = 0.2, piH0 = 0.15, pi = 0.25, alpha = 0.025)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
\keyword{internal}
