# Contributing to loo

This outlines how to propose a change to loo and is based on similar
instructions for tidyverse packages, including the contributing guidelines
generated by `usethis::use_tidy_contributing()`.

## Fixing typos

You can fix typos, spelling mistakes, or grammatical errors in the documentation
directly using the GitHub web interface, as long as the changes are made in the
_source_ file. This generally means you'll need to edit 
[roxygen2 comments](https://roxygen2.r-lib.org/articles/roxygen2.html) in an `.R`, 
not a `.Rd` file. You can find the `.R` file that generates the `.Rd` by reading
the comment in the first line.

## Bigger changes

If you want to make a bigger change, it's a good idea to first file an issue and
make sure someone from the team agrees that it’s needed. If you’ve found a bug,
please file an issue that illustrates the bug with a minimal reproducible
example (see e.g. the [tidyverse reprex instructions](https://www.tidyverse.org/help/#reprex)). 
The tidyverse guide on [how to create a great issue](https://code-review.tidyverse.org/issues/) 
has more advice.

### Pull request process

If you are new to creating pull requests here are some tips. Using the functions
from the `usethis` package is not required but can be helpful if this process is
new to you.

*   Fork the package and clone onto your computer. If you haven't done this before, we recommend using `usethis::create_from_github("stan-dev/loo", fork = TRUE)`.

*   Install all development dependencies with `devtools::install_dev_deps()`, and then make sure the package passes R CMD check by running `devtools::check()`. 
    If R CMD check doesn't pass cleanly, it's a good idea to ask for help before continuing. 
*   Create a Git branch for your pull request (PR). We recommend using `usethis::pr_init("brief-description-of-change")`.

*   Make your changes, commit to git, and then create a PR by running `usethis::pr_push()`, and following the prompts in your browser.
    The title of your PR should briefly describe the change.
    The body of your PR should contain `Fixes #issue-number`.

*  For user-facing changes, add a bullet to the top of `NEWS.md` (i.e. just below the first header). Follow the style already used in `NEWS.md`.

### Code style

*  New code should attempt to follow the style used in the package. When in doubt follow the tidyverse [style guide](https://style.tidyverse.org). 

*  We use [roxygen2](https://cran.r-project.org/package=roxygen2), with [Markdown syntax](https://cran.r-project.org/web/packages/roxygen2/vignettes/rd-formatting.html), for documentation.  

*  We use [testthat](https://cran.r-project.org/package=testthat) for unit tests. 
   Contributions with test cases included are easier to accept.  

## Code of Conduct

Please note that the loo project follows the Stan project's 
[Code of Conduct](https://discourse.mc-stan.org/t/announcing-our-new-stan-code-of-conduct/23764).
By contributing to this project you agree to abide by its terms.
