% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worldcat-api.R
\name{worldcat_api_search}
\alias{worldcat_api_search}
\title{Use the WorldCat Search API}
\usage{
worldcat_api_search(
  sru,
  max_records = 10,
  sru_query_assist = getOption("libbib.sru_query_assist", TRUE),
  frbrGrouping = "on",
  start_at = 1,
  wskey = getOption("libbib.wskey", NULL),
  more = TRUE,
  print.progress = TRUE,
  debug = FALSE
)
}
\arguments{
\item{sru}{The search query (in CQL syntax). See \code{examples} section
for some examples.}

\item{max_records}{The maximum number of search results to return.
Must be a number between 0 and 100 or \code{Inf}.
If \code{Inf}, the function will
automatically make all follow-up requests to retrieve
all search results. For safety, the default is 10.}

\item{sru_query_assist}{A logical indicating whether translation from
more human-readable aliases to the SRU search
index codes should be allowed. See details for
more information. (default is \code{TRUE}). You
can control this parameter globally by setting
\code{options("libbib.sru_query_assist")}.}

\item{frbrGrouping}{With this parameter set to "on" (default),
an attempt is made by the WorldCat API to group
together similar editions and present only the top
held record as the representative record for that group.}

\item{start_at}{The search result to start at (default is 1)}

\item{wskey}{A WorldCat API key (default is \code{getOption("libbib.wskey")})}

\item{more}{A logical indicating whether more information from the MARCXML
search results should be returned (publisher, bib level, etc....).
(Default is \code{TRUE})}

\item{print.progress}{A logical indicating whether a message should be
displayed for each API request. If \code{max_records}
is \code{Inf} a message will be displayed for every
group of 100 search results the function fetches.
(default is \code{TRUE})}

\item{debug}{A logical indicating whether the HTTP and API
responses should be printed (for debugging)
(default is \code{FALSE})}
}
\value{
A \code{data.table} containing the bibliographic metadata of the
        results, along with the total number of results.
}
\description{
Searches WorldCat using a CQL query. Returns a \code{data.table}
containing the bibliographic metadata of the results, along
with the total number of results.
}
\details{
There is an entire vignette dedicated to this function; to view it,
execute \code{vignette("using-the-worldcat-search-api")}



By default, this function allows for the usage of more human-readable
aliases to the arcane SRU search index codes. This allows you, for
example, to search using "$title" instead of "srw.ti". This behavior is
controlled using the `sru_query_assist` parameter. If it is \code{TRUE}
(the default) you can still use the formal search index codes. See
\code{vignette("using-the-worldcat-search-api")} for more information.

As with all API access functions in this package, it's up to the
user to limit their API usage so as to not get blocked. These
functions are deliberately not vectorized for this reason; they
only accept one standard number at a time.

This (and other) WorldCat API communication functions require a
WorldCat API key. The easiest way to use these functions is to
set a global options with your key:
\code{options("libbib.wskey"="YOUR KEY HERE")}
}
\examples{

\dontrun{

# A title search for "The Brothers Karamazov"
worldcat_api_search('$title = "Brothers Karamazov"')

# An exact title search for "The Brothers Karamazov"
worldcat_api_search('$title exact "Brothers Karamazov"')

# Search for title "Madame Bovary" by author "Gustave Flaubert"
# in language Greek (all results)
# (queries may span multiple lines)
sru <- '$author = "Gustave Flaubert" and $title="Madame Bovary"
          and $language=greek'
worldcat_api_search(sru, max_records=Inf)

# Hip Hop (subject) materials on Cassette, CD, or wax from years 1987 to 1990
sru <- '(($material_type=cas or $material_type=cda or $material_type=lps)
           and $subject="Rap") and $year="1987-1990"'
worldcat_api_search(sru)

# all materials with keyword "Common Lisp" at The New York Public Library
sru <- '$keyword="common lisp" and $holding_library=NYP'
worldcat_api_search(sru, max_records=Inf)

# 19th century materials on ethics (Dewey code 170s / LC Call prefix BJ)
sru <- '($dewey="17*" or $lc_call="bj*") and $year="18*"'
worldcat_api_search(sru, max_records=Inf)

# Music (Dewey 780s) materials that are only held by The New York Public
# Library (a "cg" code of 11 means there is only one holding)
# [searching with debugging]
sru <- '$dewey="78*" and $holding_library=NYP
          and $library_holdings_group=11'
worldcat_api_search(sru, debug=TRUE)

Keyword search for "danger music" from year 2010 to present
worldcat_api_search('$keyword="danger music" and $year="2010-"')

}
}
