% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/the-web.R
\name{loc_permalink_from_lccn}
\alias{loc_permalink_from_lccn}
\title{Get Library of Congress catalog permalinks from LCCNs}
\usage{
loc_permalink_from_lccn(x, normalize = TRUE, format = "")
}
\arguments{
\item{x}{A string (or vector of strings) of LCCNs}

\item{normalize}{a logical indicating whether the LCCN should be
normalized prior to creating the permalink
(default is \code{TRUE})}

\item{format}{One of "", "marcxml", "mods", "mads", or "dublin" to return
the link to the main permalink page, or the link directly
to the record's MARCXml, MODS, MADS, or Dublin Core
representation, respectively.}
}
\value{
Library of Congress permalinks using LCCNs.
}
\description{
Takes a string representation of an LCCNs. Returns permalinks
to the Library of Congress catalog entries using those LCCNs.
}
\details{
If normalize=TRUE and the LCCN is invalid, the permalink is NA.
If normalize=FALSE, the permalink may be invalid. No validity
check on the URL is performed
}
\examples{
loc_permalink_from_lccn("n78-890351")        # "https://lccn.loc.gov/n78890351"
loc_permalink_from_lccn("85-2 ")             # "https://lccn.loc.gov/85000002"
loc_permalink_from_lccn("75-425165//r75")    # "https://lccn.loc.gov/75425165"

# vectorized
loc_permalink_from_lccn(c("###78890351#", NA, "n78-890351"))

# MARCXML metadata format
loc_permalink_from_lccn("73167510", format="marcxml")
# "https://lccn.loc.gov/73167510/marcxml"

}
