% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special-attributes.R
\name{fwrite_plus_date}
\alias{fwrite_plus_date}
\title{Write a file with a date appended to the file name.}
\usage{
fwrite_plus_date(
  DT,
  fname,
  from.attribute = TRUE,
  allow.fallback.date = TRUE,
  ...
)
}
\arguments{
\item{DT}{a \code{data.table} to write to disk}

\item{fname}{The file name to write the \code{data.table} to. The
date will be appended between the file name and its
file extension}

\item{from.attribute}{A logical indicating whether the date should
be taken from the \code{lb.date} attribute of
the \code{data.table}, or whether it should be
today's date. Default (\code{TRUE}) takes it
from the \code{lb.date} attribute.}

\item{allow.fallback.date}{A logical indicating, if there is no
\code{lb.date} attribute in the supplied
\code{data.table}, whether it is permissible
to use today's date, instead.
Default is \code{TRUE}.}

\item{...}{Arbitrary arguments to pass to \code{fwrite}}
}
\description{
Takes a \code{data.table}, a file name, and writes it with
\code{data.table::fwrite}.
}
\details{
The supplied file name will be modified to include an ISO 8601 date
(yyyy-mm-dd) between the file name and the file extension. Under the
default settings, the date used will be from the \code{lb.date}
attribute of the supplied \code{data.table}. If there is no \code{lb.date}
attribute, the current date will be used, instead.

For example, if there is a \code{data.table} with an \code{lb.date}
attribute of "2021-05-08", and you supply this function with the file
name "iris.csv", the file name actually written to disk will be
"iris-2021-05-08.csv". Under the default settings, if there is no
\code{lb.date} attribute, but today's date is "2038-01-19", the file
name written to disk will be "iris-2038-01-19.csv".

The ISO 8601 date is sandwiched between the file name and the file
extension. The file extension is considered to be anything after the
first period in the base name.
For example, if the file name given is "./my.data/iris.csv.gz", the
extension is ".csv.gz". This means no period can be present in
the base file name (after any directories) with the exception of
the file extension.
}
\examples{
\dontrun{

set_lb_date(iris, "2021-05-08")
fwrite_plus_date(iris, "iris.csv.gz")
# "iris-2021-05-08.csv.gz" is now written to disk

}

}
