% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{partition_map}
\alias{partition_map}
\title{Apply function along the last dimension of an array and aggregate the results}
\usage{
partition_map(x, map_fun, reduce, partitions, ...)
}
\arguments{
\item{x}{R array or \code{LazyArray}}

\item{map_fun}{function that takes in a slice of array and an optional 
argument indicating current partition number}

\item{reduce}{function that accept a list of results returned by 
\code{map_fun}, can be missing}

\item{partitions}{integers of partitions, i.e. the slices of array to be 
applied to, can be missing. If missing, then applies to all partitions}

\item{...}{internally used}
}
\value{
If \code{reduce} is missing, returns a list of results. Each result
is returned by \code{map_fun}, and the total length equals to number of 
partitions mapped. If \code{reduce} is a function, that list of results will
be passed to \code{reduce} and \code{partition_map} returns the results 
generated from \code{reduce}.
}
\description{
Apply function along the last dimension of an array and aggregate the results
}
\examples{

# -------------------------- Ordinary R array ---------------------------

x <- array(1:24, c(2,3,4))
partition_map(x, function(slice, part){
  sum(slice)
})

# When reduce and partitions are missing, the following code is equivalent
as.list(apply(x, 3, sum))

# When reduce is present
partition_map(x, function(slice, part){
  sum(slice)
}, function(slice_sum){
  max(unlist(slice_sum))
})

# equivalently, we could call
slice_sum <- partition_map(x, function(slice, part){
  sum(slice)
})
max(unlist(slice_sum))

# When partition is specified
# Partition 1, 2, and 4 exist but 5 is missing
# when a partition is missing, the missing slice will be NA
partition_map(x, function(slice, part){
  sum(slice)
}, partitions = c(1,2,4,5))

# -------------------------- LazyArray ---------------------------
x <- lazyarray(tempfile(), storage_format = 'complex', dim = c(2,3,4))
x[] <- 1:24 + (24:1) * 1i

partition_map(x, function(slice, part){
  slice[1, ,] * slice[2, ,]
}, reduce = function(mapped_prod){
  mean(unlist(mapped_prod))
})



}
