% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-lm.R
\name{lazylm}
\alias{lazylm}
\title{Fitting linear models using \code{lazyarray}}
\usage{
lazylm(
  formula,
  data,
  fitted = FALSE,
  weights = NULL,
  offset = NULL,
  contrasts = NULL,
  na.action = getOption("na.action"),
  qr.tol = 1e-07,
  ...
)
}
\arguments{
\item{formula}{an object of class \code{\link[stats]{formula}}. For variable
names to be used, see 'Details'}

\item{data}{a \code{lazyarray} object}

\item{fitted}{whether to calculate fitted data and residuals. This may
take time and memory if data is large}

\item{weights, offset, contrasts, na.action}{see \code{\link[stats]{lm}}}

\item{qr.tol}{the tolerance for detecting linear dependencies in the 
partitions of \code{data}; see \code{\link{qr}}}

\item{...}{passed to \code{\link{chunk_map}}}
}
\value{
An object of class \code{c("lazylm", "lm")} or for multiple 
responses of class \code{c("lazylm", "mlm")}.
}
\description{
Fitting linear models using \code{lazyarray}
}
\details{
The array will be reshaped to a matrix first before fitting the 
linear models. A \eqn{100 x 20 x 5} array will be reshaped to a 
\eqn{2000 x 5} lazy matrix.
The variables are the partitions of the array. If \code{dimnames}
are set for the last margin index, then those will be used as variable 
names, otherwise \code{lazylm} automatically assign 
\eqn{"V1", "V2", "V3", ...} as each partition names.
}
\examples{

library(lazyarray)
arr <- array(rnorm(72), c(6,3,4))
arr[1,1,1] <- NA        # Allow NA to be treated
offset = rnorm(18)    # offset and weights are optional
weights = runif(18)

formula <- V1 ~ .-V2-1 + (V2 > 0)

data <- as.lazyarray(arr, type = 'file')
object <- lazylm(formula, data, weights = weights, offset = offset)


# Compare to stats::lm
dim(arr) <- c(18, 4)
lm_data <- as.data.frame(arr)
flm <- lm(formula, lm_data, weights = weights, offset = offset)

cbind(coef(object), coef(flm))
cbind(resid(object), resid(flm))
cbind(fitted(object), fitted(flm))
summary(object)
summary(flm)

}
