% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R
\name{auto_clear_lazyarray}
\alias{auto_clear_lazyarray}
\title{Automatically remove array data}
\usage{
auto_clear_lazyarray(x, onexit = FALSE)
}
\arguments{
\item{x}{'lazyarray' instance}

\item{onexit}{passed to \code{\link{reg.finalizer}}}
}
\description{
Remove the files containing array data once no
'lazyarray' instance is using the folder. Require
installation of \code{dipsaus} package (at least version 0.0.8).
}
\details{
\code{auto_clear_lazyarray} attempts to remove the entire folder
containing array data. However, if some files are not created by the
array, only partition data and meta file will be removed, all the 
artifacts will remain and warning will be displayed. One exception is
if all files left in the array directory are \code{*.meta} files, 
all these meta files will be removed along with the folder.
}
\examples{

path <- tempfile()
arr_dbl <- lazyarray(path, storage_format = 'double',
                     dim = 2:4, meta_name = 'meta-dbl.meta')
arr_dbl[] <- 1:24
auto_clear_lazyarray(arr_dbl)

arr_chr <- lazyarray(path, storage_format = 'character',
                     dim = 2:4, meta_name = 'meta-chr.meta')
auto_clear_lazyarray(arr_chr)

# remove either one, the directory still exists
rm(arr_dbl); invisible(gc(verbose = FALSE))

arr_chr[1,1,1]

# Remove the other one, and path will be removed
rm(arr_chr); invisible(gc(verbose = FALSE))

dir.exists(path)
arr_check <- lazyarray(path, storage_format = 'character',
                       dim = 2:4, meta_name = 'meta-chr')

# data is removed, so there should be no data (NAs)
arr_check[]

}
\author{
Zhengjia Wang
}
