% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{kim_filter_cpp}
\alias{kim_filter_cpp}
\title{Kim Filter}
\usage{
kim_filter_cpp(ssm, yt, Xo = NULL, Xs = NULL, weight = NULL, smooth = FALSE)
}
\arguments{
\item{ssm}{list describing the state space model, must include names
B0 - N_b x 1 x n_state array of matrices, initial guess for the unobserved components 
P0 - N_b x N_b x n_state array of matrices, initial guess for the covariance matrix of the unobserved components
Dm - N_b x 1 x n_state array of matrices, constant matrix for the state equation
Am - N_y x 1 x n_state array of matrices, constant matrix for the observation equation
Fm - N_b X p x n_state array of matrices, state transition matrix
Hm - N_y x N_b x n_state array of matrices, observation matrix
Qm - N_b x N_b x n_state array of matrices, state error covariance matrix
Rm - N_y x N_y x n_state array of matrices, state error covariance matrix
betaO - N_y x N_o x n_state array of matrices, coefficient matrix for the observation exogenous data
betaS - N_b x N_s x n_state array of matrices, coefficient matrix for the state exogenous data
Pm - n_state x n_state matrix, state transition probability matrix}

\item{yt}{N x T matrix of data}

\item{Xo}{N_o x T matrix of exogenous observation data}

\item{Xs}{N_s x T matrix of exogenous state}

\item{weight}{column matrix of weights, T x 1}

\item{smooth}{boolean indication whether to run the backwards smoother}
}
\value{
list of cubes and matrices output by the Kim filter
}
\description{
Kim Filter
}
