% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyATMvb.R
\name{keyATMvb}
\alias{keyATMvb}
\title{keyATM with Collapsed Variational Bayes}
\usage{
keyATMvb(
  docs,
  model,
  no_keyword_topics,
  keywords = list(),
  model_settings = list(),
  vb_options = list(),
  priors = list(),
  options = list(),
  keep = list()
)
}
\arguments{
\item{docs}{texts read via \code{\link[=keyATM_read]{keyATM_read()}}}

\item{model}{keyATM model: \code{base}, \code{covariates}, and \code{dynamic}}

\item{no_keyword_topics}{the number of regular topics}

\item{keywords}{a list of keywords}

\item{model_settings}{a list of model specific settings (details are in the online documentation)}

\item{vb_options}{a list of settings for Variational Bayes \itemize{
\item \strong{convtol}: the default is \code{1e-4}
\item \strong{init}: \code{mcmc} (default) or \code{random}
}}

\item{priors}{a list of priors of parameters}

\item{options}{a list of options same as \code{\link[=keyATM]{keyATM()}}. Options are used when initialization method is \code{mcmc}.}

\item{keep}{a vector of the names of elements you want to keep in output}
}
\value{
A \code{keyATM_output} object
}
\description{
\strong{Experimental feature:} Fit keyATM base with Collapsed Variational Bayes
}
\seealso{
\url{https://keyatm.github.io/keyATM/articles/pkgdown_files/keyATMvb.html}
}
