% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{as_graphnel}
\alias{as_graphnel}
\title{Convert igraph graphs to graphNEL objects from the graph package}
\usage{
as_graphnel(graph)
}
\arguments{
\item{graph}{An igraph graph object.}
}
\value{
\code{as_graphnel()} returns a graphNEL graph object.
}
\description{
The graphNEL class is defined in the \code{graph} package, it is another
way to represent graphs. These functions are provided to convert between
the igraph and the graphNEL objects.
}
\details{
\code{as_graphnel()} converts an igraph graph to a graphNEL graph. It
converts all graph/vertex/edge attributes. If the igraph graph has a
vertex attribute \sQuote{\code{name}}, then it will be used to assign
vertex names in the graphNEL graph. Otherwise numeric igraph vertex ids
will be used for this purpose.
}
\examples{
\dontshow{if (rlang::is_installed("graph")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Undirected
g <- make_ring(10)
V(g)$name <- letters[1:10]
GNEL <- as_graphnel(g)
g2 <- graph_from_graphnel(GNEL)
g2

## Directed
g3 <- make_star(10, mode = "in")
V(g3)$name <- letters[1:10]
GNEL2 <- as_graphnel(g3)
g4 <- graph_from_graphnel(GNEL2)
g4
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=graph_from_graphnel]{graph_from_graphnel()}} for the other direction,
\code{\link[=as_adjacency_matrix]{as_adjacency_matrix()}}, \code{\link[=graph_from_adjacency_matrix]{graph_from_adjacency_matrix()}},
\code{\link[=as_adj_list]{as_adj_list()}} and \code{\link[=graph_from_adj_list]{graph_from_adj_list()}} for
other graph representations.

Other conversion: 
\code{\link{as.matrix.igraph}()},
\code{\link{as_adj_list}()},
\code{\link{as_adjacency_matrix}()},
\code{\link{as_biadjacency_matrix}()},
\code{\link{as_data_frame}()},
\code{\link{as_directed}()},
\code{\link{as_edgelist}()},
\code{\link{as_long_data_frame}()},
\code{\link{graph_from_adj_list}()},
\code{\link{graph_from_graphnel}()}
}
\concept{conversion}
