% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow.R
\name{min_st_separators}
\alias{min_st_separators}
\title{Minimum size vertex separators}
\usage{
min_st_separators(graph)
}
\arguments{
\item{graph}{The input graph. It may be directed, but edge directions are
ignored.}
}
\value{
A list of numeric vectors. Each vector contains a vertex set
(defined by vertex ids), each vector is an (s,t) separator of the input
graph, for some \eqn{s} and \eqn{t}.
}
\description{
List all vertex sets that are minimal (s,t) separators for some s and t, in
an undirected graph.
}
\details{
A \eqn{(s,t)} vertex separator is a set of vertices, such that after their
removal from the graph, there is no path between \eqn{s} and \eqn{t} in the
graph.

A \eqn{(s,t)} vertex separator is minimal if none of its subsets is an
\eqn{(s,t)} vertex separator.
}
\examples{

ring <- make_ring(4)
min_st_separators(ring)

chvatal <- make_graph("chvatal")
min_st_separators(chvatal)
}
\references{
Anne Berry, Jean-Paul Bordat and Olivier Cogis: Generating All
the Minimal Separators of a Graph, In: Peter Widmayer, Gabriele Neyer and
Stephan Eidenbenz (editors): \emph{Graph-theoretic concepts in computer
science}, 1665, 167--172, 1999. Springer.
}
\seealso{
Other flow: 
\code{\link{dominator_tree}()},
\code{\link{edge_connectivity}()},
\code{\link{is_min_separator}()},
\code{\link{is_separator}()},
\code{\link{max_flow}()},
\code{\link{min_cut}()},
\code{\link{min_separators}()},
\code{\link{st_cuts}()},
\code{\link{st_min_cuts}()},
\code{\link{vertex_connectivity}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{flow}
\keyword{graphs}
