% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_constant_cols.R
\name{drop_constant_cols}
\alias{drop_constant_cols}
\title{Drop constant columns}
\usage{
drop_constant_cols(DT, copy = FALSE)
}
\arguments{
\item{DT}{A \code{data.table}.}

\item{copy}{(logical, default: \code{FALSE}) Whether the \code{data.table} should be copied before any columns are dropped. If \code{FALSE}, the default, columns are dropped from \code{DT} by reference.}
}
\description{
Drops columns that have only one value in a \code{data.table}.
}
\details{
If \code{DT} is a \code{data.frame} that is not a \code{data.table},
constant columns are still dropped, but since \code{DT} will be copied, \code{copy} should be set 
to \code{TRUE} to avoid a warning. If \code{DT} is a \code{data.frame} and all but one
of the columns are constant, a \code{data.frame}
will still be returned, as opposed to the values of the sole remaining column, which is the 
default behaviour of base \code{data.frame}.

If all columns are constant, \code{drop_constant_cols} returns a Null data table if \code{DT} is a \code{data.table},
but a data frame with 0 columns and \code{nrow(DT)} otherwise.
}
\examples{
library(data.table)
X <- data.table(x = c(1, 1), y = c(1, 2))
drop_constant_cols(X)



}
