% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pad_fn.R
\name{pad_fn}
\alias{pad_fn}
\title{Pad a vector of numbers to align on the decimal point.}
\usage{
pad_fn(x, nsmall = 2, pad0)
}
\arguments{
\item{x}{A vector of numbers to pad/align at the decimal point}

\item{nsmall}{The max number of decimal places to round at/display}

\item{pad0}{A logical, indicating whether to pad the values with trailing zeros.}
}
\value{
Returns a vector of equal length to the input vector
}
\description{
This helper function adds whitespace to numeric values so that they can
be aligned on the decimal without requiring additional trailing zeroes.
This function is intended to use within the \code{gt::fmt()} function.
}
\section{Figures}{

\if{html}{\figure{gt_pad_fn.png}{options: width=20\%}}
}

\section{Function ID}{

2-3
}

\examples{

library(gt)
padded_tab <- data.frame(x = c(1.2345, 12.345, 123.45, 1234.5, 12345)) \%>\%
  gt() \%>\%
  fmt(fns = function(x) {
    pad_fn(x, nsmall = 4)
  }) \%>\%
  tab_style(
    # MUST USE A MONO-SPACED FONT
    # https://fonts.google.com/?category=Monospace
    style = cell_text(font = google_font("Fira Mono")),
    locations = cells_body(columns = x)
  )

}
\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_fa_repeats}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_border}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_multi_rows}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack_color}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{img_header}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
