% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two-column-layouts.R
\name{gt_double_table}
\alias{gt_double_table}
\title{Take data, a gt-generating function, and create a list of two tables}
\usage{
gt_double_table(data, gt_fn, nrows = NULL, noisy = TRUE)
}
\arguments{
\item{data}{A \code{tibble} or dataframe to be passed into the supplied \code{gt_fn}}

\item{gt_fn}{A user-defined function that has one argument, this argument should pass data to the \code{gt::gt()} function, which will be supplied by the \code{data} argument. It should follow the pattern of \code{gt_function <- function(x) gt(x) \%>\% more_gt_code...}.}

\item{nrows}{The number of rows to split at, defaults to \code{NULL} and will attempt to split approximately 50/50 in the left vs right table.}

\item{noisy}{A logical indicating whether to return the warning about not supplying \code{nrows} argument.}
}
\value{
a \code{list()} of two \code{gt} tables
}
\description{
The \code{gt_double_table} function takes some data and a user-supplied
function to generate two tables in a list. To convert existing \code{gt::gt()}
code to a function, you can follow the approximate pattern:
\code{gt_fn <- function(x){gt(x) \%>\% more_gt_code}}

Your function should only have a \strong{single argument}, which is the \strong{data}
to be supplied directly into the \code{gt::gt()} function. This function is
intended to be passed directly into \code{gt_two_column_layout()}, for printing
it to the viewer, saving it to a \code{.png}, or returning the raw HTML.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(gt)
# define your own function
my_gt_function <- function(x) \{
  gt(x) \%>\%
    gtExtras::gt_color_rows(columns = mpg, domain = range(mtcars$mpg)) \%>\%
    tab_options(data_row.padding = px(3))
\}

two_tables <- gt_double_table(mtcars, my_gt_function, nrows = 16)

# list of two gt_tbl objects
# ready to pass to gtExtras::gt_two_column_layout()
str(two_tables, max.level = 1)

#> List of 2
#> $ :List of 16
#> ..- attr(*, "class")= chr [1:2] "gt_tbl" "list"
#> $ :List of 16
#> ..- attr(*, "class")= chr [1:2] "gt_tbl" "list"
}\if{html}{\out{</div>}}
}

\section{Function ID}{

2-13
}

\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_fa_repeats}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_border}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_multi_rows}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack_color}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{img_header}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
