% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed_design_rd.R
\name{fixed_design_rd}
\alias{fixed_design_rd}
\title{Fixed design for binary outcome measuring in risk difference}
\usage{
fixed_design_rd(
  alpha = 0.025,
  power = NULL,
  ratio = 1,
  p_c,
  p_e,
  rd0 = 0,
  n = NULL
)
}
\arguments{
\item{alpha}{One-sided Type I error (strictly between 0 and 1).}

\item{power}{Power (\code{NULL} to compute power or strictly between 0
and \code{1 - alpha} otherwise).}

\item{ratio}{Experimental:Control randomization ratio.}

\item{p_c}{A numerical value of the control arm rate.}

\item{p_e}{A numerical value of the experimental arm rate.}

\item{rd0}{Risk difference under null hypothesis, default is 0.}

\item{n}{Sample size. If NULL with power input, the sample size will be
computed to achieve the targeted power}
}
\value{
A table.
}
\description{
Computes fixed design sample size (given power) or power (given sample size)
for binary outcome measuring in risk difference (Mehrotra and Railkar, 2000).
Returns a list with a basic summary.
}
\examples{
library(dplyr)

# Example 1: given power and compute sample size
x <- fixed_design_rd(
  alpha = 0.025, power = 0.9, p_c = .15, p_e = .1,
  rd0 = 0, ratio = 1
)
x \%>\% summary()

# Example 2: given sample size and compute power
x <- fixed_design_rd(
  alpha = 0.025, power = NULL, p_c = .15, p_e = .1,
  rd0 = 0, n = 2000, ratio = 1
)
x \%>\% summary()
}
