% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_info_wlr.R
\name{gs_info_wlr}
\alias{gs_info_wlr}
\title{Information and effect size for weighted log-rank test}
\usage{
gs_info_wlr(
  enroll_rate = define_enroll_rate(duration = c(2, 2, 10), rate = c(3, 6, 9)),
  fail_rate = define_fail_rate(duration = c(3, 100), fail_rate = log(2)/c(9, 18), hr =
    c(0.9, 0.6), dropout_rate = 0.001),
  ratio = 1,
  event = NULL,
  analysis_time = NULL,
  weight = wlr_weight_fh,
  approx = "asymptotic",
  interval = c(0.01, 100)
)
}
\arguments{
\item{enroll_rate}{An \code{enroll_rate} data frame with or without stratum
created by \code{\link[=define_enroll_rate]{define_enroll_rate()}}.}

\item{fail_rate}{Failure and dropout rates.}

\item{ratio}{Experimental:Control randomization ratio.}

\item{event}{Targeted minimum events at each analysis.}

\item{analysis_time}{Targeted minimum study duration at each analysis.}

\item{weight}{Weight of weighted log rank test:
\itemize{
\item \code{"1"} = unweighted.
\item \code{"n"} = Gehan-Breslow.
\item \code{"sqrtN"} = Tarone-Ware.
\item \code{"FH_p[a]_q[b]"} = Fleming-Harrington with p=a and q=b.
}}

\item{approx}{Approximate estimation method for Z statistics.
\itemize{
\item \code{"event_driven"} = only work under proportional hazard model with log rank test.
\item \code{"asymptotic"}.
}}

\item{interval}{An interval that is presumed to include the time at which
expected event count is equal to targeted event.}
}
\value{
A tibble with columns Analysis, Time, N, Events, AHR, delta, sigma2,
theta, info, info0.
\code{info} and \code{info0} contain statistical information under H1, H0, respectively.
For analysis \code{k}, \code{Time[k]} is the maximum of \code{analysis_time[k]} and the
expected time required to accrue the targeted \code{event[k]}.
\code{AHR} is the expected average hazard ratio at each analysis.
}
\description{
Based on piecewise enrollment rate, failure rate, and dropout rates computes
approximate information and effect size using an average hazard ratio model.
}
\details{
The \code{\link[=ahr]{ahr()}} function computes statistical information at targeted event times.
The \code{\link[=expected_time]{expected_time()}} function is used to get events and average HR at
targeted \code{analysis_time}.
}
\examples{
library(gsDesign2)

# Set enrollment rates
enroll_rate <- define_enroll_rate(duration = 12, rate = 500 / 12)

# Set failure rates
fail_rate <- define_fail_rate(
  duration = c(4, 100),
  fail_rate = log(2) / 15, # median survival 15 month
  hr = c(1, .6),
  dropout_rate = 0.001
)

# Set the targeted number of events and analysis time
event <- c(30, 40, 50)
analysis_time <- c(10, 24, 30)

gs_info_wlr(
  enroll_rate = enroll_rate, fail_rate = fail_rate,
  event = event, analysis_time = analysis_time
)
}
