% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-surv.R
\name{predict.grpsurv}
\alias{predict.grpsurv}
\title{Model predictions for grpsurv objects}
\usage{
\method{predict}{grpsurv}(
  object,
  X,
  type = c("link", "response", "survival", "hazard", "median", "norm", "coefficients",
    "vars", "nvars", "groups", "ngroups"),
  lambda,
  which = 1:length(object$lambda),
  ...
)
}
\arguments{
\item{object}{Fitted \code{grpsurv} model object.}

\item{X}{Matrix of values at which predictions are to be made. Not required for some \code{type} values.}

\item{type}{Type of prediction:
\itemize{
\item \code{link}: linear predictors
\item \code{response}: risk (i.e., \code{exp(link)})
\item \code{survival}: the estimated survival function
\item \code{hazard}: the estimated cumulative hazard function
\item \code{median}: median survival time
\item The other options are all identical to their \code{\link[=grpreg]{grpreg()}} counterparts
}}

\item{lambda}{Regularization parameter at which predictions are requested. For values of \code{lambda} not in the sequence of fitted models, linear interpolation is used.}

\item{which}{Indices of the penalty parameter \code{lambda} at which predictions are required. Default: all indices. If \code{lambda} is specified, this will override \code{which}.}

\item{...}{Not used.}
}
\value{
The object returned depends on type.
}
\description{
Similar to other predict methods, this function returns predictions from a fitted \code{grpsurv} object.
}
\details{
Estimation of baseline survival function conditional on the estimated values of \code{beta} is carried out according to the method described in Chapter 4.3 of Kalbfleisch and Prentice.
}
\examples{
data(Lung)
X <- Lung$X

y <- Lung$y
group <- Lung$group
 
fit <- grpsurv(X, y, group)
coef(fit, lambda=0.05)
head(predict(fit, X, type="link", lambda=0.05))
head(predict(fit, X, type="response", lambda=0.05))
 
# Survival function
S <- predict(fit, X[1,], type="survival", lambda=0.05)
S(100)
S <- predict(fit, X, type="survival", lambda=0.05)
plot(S, xlim=c(0,200))
 
# Medians
predict(fit, X[1,], type="median", lambda=0.05)
M <- predict(fit, X, type="median")
M[1:10, 1:10]
 
# Nonzero coefficients
predict(fit, type="vars", lambda=c(0.1, 0.01))
predict(fit, type="nvars", lambda=c(0.1, 0.01))
}
\references{
\itemize{
\item Kalbfleish JD and Prentice RL (2002). The Statistical Analysis of Failure Time Data, 2nd edition. Wiley.
}
}
\seealso{
\code{\link[=grpsurv]{grpsurv()}}
}
\author{
Patrick Breheny
}
