% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern-both-text.R
\name{grid.pattern_text}
\alias{grid.pattern_text}
\title{Text character patterned grobs}
\usage{
grid.pattern_text(
  x = c(0, 0, 1, 1),
  y = c(1, 0, 0, 1),
  id = 1L,
  ...,
  colour = gp$col \%||\% "grey20",
  angle = 30,
  spacing = 0.05,
  xoffset = 0,
  yoffset = 0,
  units = "snpc",
  scale = 0.5,
  shape = "X",
  grid = "square",
  type = NULL,
  subtype = NULL,
  rot = 0,
  alpha = gp$alpha \%||\% NA_real_,
  size = gp$fontsize \%||\% 12,
  fontfamily = gp$fontfamily \%||\% "sans",
  fontface = gp$fontface \%||\% "plain",
  use_R4.1_masks = getOption("ggpattern_use_R4.1_masks",
    getOption("ggpattern_use_R4.1_features")),
  png_device = NULL,
  res = getOption("ggpattern_res", 72),
  default.units = "npc",
  name = NULL,
  gp = gpar(),
  draw = TRUE,
  vp = NULL
)
}
\arguments{
\item{x}{A numeric vector or unit object specifying x-locations of the pattern boundary.}

\item{y}{A numeric vector or unit object specifying y-locations of the pattern boundary.}

\item{id}{A numeric vector used to separate locations in x, y into multiple boundaries.
All locations within the same \code{id} belong to the same boundary.}

\item{...}{Currently ignored.}

\item{colour}{Stroke colour(s).}

\item{angle}{Rotation angle in degrees.}

\item{spacing}{Spacing between repetitions of pattern (in \code{units} units).}

\item{xoffset}{Shift pattern along x axis (in \code{units} units).}

\item{yoffset}{Shift pattern along y axis (in \code{units} units).}

\item{units}{\code{\link[grid:unit]{grid::unit()}} units for \code{spacing}, \code{xoffset}, and \code{yoffset} parameters.}

\item{scale}{For star polygons, multiplier (between 0 and 1)
applied to exterior radius to get interior radius.}

\item{shape}{A character or expression vector.
See \code{label} argument of \code{\link[grid:grid.text]{grid::textGrob()}} for more details.}

\item{grid}{Adjusts placement and density of certain graphical elements.
\code{"square"} (default) is a square grid.
\code{"hex"} is a hexagonal grid suitable for hexagonal and triangular tiling.
\code{"hex_circle"} is a hexagonal grid suitable for circle packing.
\code{"elongated_triangle"} is a grid used for the "elongated triangle" tiling.}

\item{type}{Adjusts the repeating of certain aesthetics such as color.
Can use any type in \code{names_hex}, \code{names_square}, or \code{names_weave}.
See for \code{\link[=pattern_hex]{pattern_hex()}}, \code{\link[=pattern_square]{pattern_square()}}, and \code{\link[=pattern_weave]{pattern_weave()}} for
more information about supported \code{type} arguments.}

\item{subtype}{See for \code{\link[=pattern_hex]{pattern_hex()}}, \code{\link[=pattern_square]{pattern_square()}}, and \code{\link[=pattern_weave]{pattern_weave()}} for
more information about supported \code{subtype} arguments.}

\item{rot}{Angle to rotate regular polygon (degrees, counter-clockwise).}

\item{alpha}{Alpha (between 0 and 1) or \code{NA} (default, preserves colors' alpha value).}

\item{size}{Fontsize}

\item{fontfamily}{The font family.  See \code{\link[grid:gpar]{grid::gpar()}} for more details.}

\item{fontface}{The font face.  See \code{\link[grid:gpar]{grid::gpar()}} for more details.}

\item{use_R4.1_masks}{If \code{TRUE} use the grid mask feature introduced in R v4.1.0.
If \code{FALSE} do a \code{rasterGrob} approximation.
If \code{NULL} try to guess an appropriate choice.
Note not all graphic devices support the grid mask feature.}

\item{png_device}{\dQuote{png} graphics device to save intermediate raster data with if \code{use_R4.1_masks} is \code{FALSE}.
If \code{NULL} and suggested package \code{ragg} is available
and versions are high enough we directly capture masked raster via \code{\link[ragg:agg_capture]{ragg::agg_capture()}}.
Otherwise we will use \code{png_device}
(default \code{\link[ragg:agg_png]{ragg::agg_png()}} if available else \code{\link[grDevices:png]{grDevices::png()}}) and \code{\link[png:readPNG]{png::readPNG()}}
to manually compute a masked raster.}

\item{res}{Resolution of desired \code{rasterGrob} in pixels per inch if \code{use_R4.1_masks} is \code{FALSE}.}

\item{default.units}{A string indicating the default units to use if \code{x} or \code{y}
are only given as numeric vectors.}

\item{name}{ A character identifier. }

\item{gp}{An object of class \code{"gpar"}, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}

\item{draw}{A logical value indicating whether graphics output
    should be produced.}

\item{vp}{A Grid viewport object (or NULL).}
}
\value{
A grid grob object invisibly.  If \code{draw} is \code{TRUE} then also draws to the graphic device as a side effect.
}
\description{
\code{grid.pattern_text()} draws a text character pattern onto the graphic device.
}
\examples{
if (capabilities("png") &&
    gridpattern:::device_supports_unicode()) {
  x_hex <- 0.5 + 0.5 * cos(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
  y_hex <- 0.5 + 0.5 * sin(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))

  playing_card_symbols <- c("\u2660", "\u2665", "\u2666", "\u2663")
  grid.pattern_text(x_hex, y_hex,
                   shape = playing_card_symbols,
                   colour = c("black", "red", "red", "black"),
                   size = 18, spacing = 0.1, angle = 0)
}
}
