% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/historical.R
\name{peay_path_value}
\alias{peay_path_value}
\title{Peay's Path Value Measure}
\usage{
peay_path_value(sociomatrix, path)
}
\arguments{
\item{sociomatrix}{a nonnegative, real valued sociomatrix.}

\item{path}{an integer vector of node indices from \code{sociomatrix}.}
}
\description{
Calculates path value as defined in Peay (1980). That is, returns the
value of the weakest connection in the path, if all edges exist. 
Otherwise, returns 0.
}
\examples{
## Calculate Peay's Path Value along a path in a sociomatrix
peay_path_value(YangKnoke01, path = c(1,2,5))

## This path doesn't exist
peay_path_value(YangKnoke01, path = c(1,2,4,5))

}
\seealso{
\code{\link{peay_average_path_value}}
}
