% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/historical.R
\name{flament_average_path_length}
\alias{flament_average_path_length}
\title{Yang and Knoke's Average Path Length}
\usage{
flament_average_path_length(sociomatrix, path)
}
\arguments{
\item{sociomatrix}{a nonnegative, real valued sociomatrix.}

\item{path}{an integer vector of node indices from \code{sociomatrix}.}
}
\description{
Calculates 'APL' (Average Path Length) as defined in Yang, Knoke (2001).
Called \code{flament_average_path_length} in homage to A.C. Flament, who defined
path length in 1963.
}
\examples{
## Calculate 'APL' of a path in a sociomatrix
flament_average_path_length(YangKnoke01, path = c(1,2,5))

## This path doesn't exist
flament_average_path_length(YangKnoke01, path = c(1,2,4,5))

}
\seealso{
\code{\link{flament_path_length}}
}
