% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/service-google.R
\name{create_completion_google}
\alias{create_completion_google}
\title{Generate text completions using Google AI Studio's API}
\usage{
create_completion_google(
  prompt,
  model = "gemini-pro",
  key = Sys.getenv("GOOGLE_API_KEY")
)
}
\arguments{
\item{prompt}{The prompt for generating completions}

\item{model}{The model to use for generating text. By default, the
function will try to use "text-bison-001"}

\item{key}{The API key for accessing Google AI Studio's API. By default, the
function will try to use the \code{GOOGLE_API_KEY} environment variable.}
}
\value{
A list with the generated completions and other information returned
by the API.
}
\description{
Generate text completions using Google AI Studio's API
}
\examples{
\dontrun{
create_completion_google(
  prompt = "Write a story about a magic backpack",
  temperature = 1.0,
  candidate_count = 3
)
}
}
