% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future.R
\name{gce_vm_cluster}
\alias{gce_vm_cluster}
\title{Make a VM cluster suitable for running parallel workloads}
\usage{
gce_vm_cluster(
  vm_prefix = "r-cluster-",
  cluster_size = 3,
  docker_image = NULL,
  ...,
  ssh_args = NULL,
  project = gce_get_global_project(),
  zone = gce_get_global_zone()
)
}
\arguments{
\item{vm_prefix}{The prefix of the VMs you want to make. Will be appended the cluster number}

\item{cluster_size}{The number of VMs in your cluster}

\item{docker_image}{The docker image the jobs on the cluster will run on. Default NULL will use \code{rocker/r-parallel}}

\item{...}{Passed to \link{gce_vm_template}}

\item{ssh_args}{A list of optional arguments that will be passed to \link{gce_ssh_setup}}

\item{project}{The project to launch the cluster in}

\item{zone}{The zone to launch the cluster in}
}
\description{
This wraps the commands for creating a cluster suitable for \link[future]{future} workloads.
}
\examples{

\dontrun{
library(future)
library(googleComputeEngineR)

vms <- gce_vm_cluster()

## make a future cluster
plan(cluster, workers = as.cluster(vms))

}
}
