% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{gce_shiny_addapp}
\alias{gce_shiny_addapp}
\title{Add Shiny app to a Shiny template instance}
\usage{
gce_shiny_addapp(instance, app_image, dockerfolder = NULL)
}
\arguments{
\item{instance}{The instance running Shiny}

\item{app_image}{The name of the Docker image to create or use existing from Google Container Registry. Must be numbers, dashes or lowercase letters only.}

\item{dockerfolder}{The folder location containing the \code{Dockerfile} and app dependencies}
}
\value{
The instance
}
\description{
Add a local shiny app to a running Shiny VM installed via \link{gce_vm_template} 
  via \link{docker_build} and \link{gce_push_registry} / \link{gce_pull_registry}.
}
\details{
To deploy a Shiny app, you first need to construct a \code{Dockerfile} which load the R packages and
  dependencies, as well as copying over the Shiny app in the same folder.

This function will take the Dockerfile, build it into a Docker image and 
  upload it to Google Container Registry for use later.

If already created, then the function will download the \code{app_image} from Google Container Registry 
  and start it on the instance provided. 

Any existing Shiny Docker containers are stopped and removed, 
  so if you want multiple apps put them in the same \code{Dockerfile}.
}
\section{Dockerfile}{


Example \code{Dockerfile}'s are found in 
\code{system.file("dockerfiles",package = "googleComputeEngineR")}

The Dockerfile is in the same folder as your shiny app, 
which consists of a \code{ui.R} and \code{server.R} in a shiny subfolder.  
This is copied into the Dockerfile in the last line.  
Change the name of the subfolder to have that name appear 
in the final URL of the Shinyapp. 

This is then run using the R commands below:
}

\examples{
\dontrun{

vm <- gce_vm("shiny-test",  
             template = "shiny", 
             predefined_type = "n1-standard-1")
             
vm <- vm_ssh_setup(vm)

app_dir <- system.file("dockerfiles","shiny-googleAuthRdemo",
                       package = "googleComputeEngineR") 
                       
gce_shiny_addapp(vm, app_image = "gceshinydemo", dockerfolder = app_dir)

# a new VM, it loads the Shiny docker image from before
gce_shiny_addapp(vm2, app_image = "gceshinydemo")

}

}
\seealso{
The vignette entry called \code{Shiny App} has examples and a walk through.
}
