% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harbor_docker.R
\name{docker_cmd}
\alias{docker_cmd}
\title{Run a docker command on a host.}
\usage{
docker_cmd(
  host,
  cmd = NULL,
  args = NULL,
  docker_opts = NULL,
  capture_text = FALSE,
  ...
)
}
\arguments{
\item{host}{A host object.}

\item{cmd}{A docker command, such as "run" or "ps"}

\item{args}{Arguments to pass to the docker command}

\item{docker_opts}{Options to docker. These are things that come before the
docker command, when run on the command line.}

\item{capture_text}{If \code{FALSE} (the default), return the host object.
This is useful for chaining functions. If \code{TRUE}, capture the text
output from both stdout and stderr, and return that. Note that \code{TRUE}
may not be available on all types of hosts.}

\item{...}{Other arguments passed to the SSH command for the host}
}
\description{
Run a docker command on a host.
}
\examples{
\dontrun{
docker_cmd(localhost, "ps", "-a")
}
}
\author{
Winston Change \email{winston@stdout.org}
}
