% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disks.R
\name{AttachedDisk}
\alias{AttachedDisk}
\title{AttachedDisk Object}
\usage{
AttachedDisk(
  autoDelete = NULL,
  boot = NULL,
  deviceName = NULL,
  diskEncryptionKey = NULL,
  index = NULL,
  initializeParams = NULL,
  interface = NULL,
  licenses = NULL,
  mode = NULL,
  source = NULL,
  type = NULL
)
}
\arguments{
\item{autoDelete}{Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance)}

\item{boot}{Indicates that this is a boot disk}

\item{deviceName}{Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance}

\item{diskEncryptionKey}{Encrypts or decrypts a disk using a customer-supplied encryption key}

\item{index}{Assigns a zero-based index to this disk, where 0 is reserved for the boot disk}

\item{initializeParams}{A \link{gce_make_boot_disk} object for creating boot disks. Cannot be used with \code{source} also defined.}

\item{interface}{Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME}

\item{licenses}{[Output Only] Any valid publicly visible licenses}

\item{mode}{The mode in which to attach this disk, either READ_WRITE or READ_ONLY}

\item{source}{Specifies a valid partial or full URL to an existing Persistent Disk resource}

\item{type}{Specifies the type of the disk, either SCRATCH or PERSISTENT}
}
\value{
AttachedDisk object
}
\description{
AttachedDisk Object
}
\details{
An instance-attached disk resource.
}
\seealso{
Other AttachedDisk functions: 
\code{\link{gce_attach_disk}()}
}
\concept{AttachedDisk functions}
\keyword{internal}
