% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{translate}
\alias{translate}
\title{Convert raster data between different formats}
\usage{
translate(src_filename, dst_filename, cl_arg = NULL, quiet = FALSE)
}
\arguments{
\item{src_filename}{Character string. Filename of the source raster.}

\item{dst_filename}{Character string. Filename of the output raster.}

\item{cl_arg}{Optional character vector of command-line arguments for
\code{gdal_translate} (see URL above).}

\item{quiet}{Logical scalar. If \code{TRUE}, a progress bar will not be
displayed. Defaults to \code{FALSE}.}
}
\value{
Logical indicating success (invisible \code{TRUE}).
An error is raised if the operation fails.
}
\description{
\code{translate()} is a wrapper of the \command{gdal_translate} command-line
utility (see \url{https://gdal.org/programs/gdal_translate.html}).
The function can be used to convert raster data between different
formats, potentially performing some operations like subsetting,
resampling, and rescaling pixels in the process. Refer to the GDAL
documentation at the URL above for a list of command-line arguments that
can be passed in \code{cl_arg}.
}
\examples{
# convert the elevation raster to Erdas Imagine format and resample to 90m
elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")

# command-line arguments for gdal_translate
args <- c("-tr", "90", "90", "-r", "average")
args <- c(args, "-of", "HFA", "-co", "COMPRESSED=YES")

img_file <- paste0(tempdir(), "/", "storml_elev_90m.img")
translate(elev_file, img_file, args)

ds <- new(GDALRaster, img_file)
ds$getDriverLongName()
ds$bbox()
ds$res()
ds$getStatistics(band=1, approx_ok=FALSE, force=TRUE)
ds$close()
}
\seealso{
\code{\link[=GDALRaster]{GDALRaster-class}}, \code{\link[=rasterFromRaster]{rasterFromRaster()}}, \code{\link[=warp]{warp()}}

\code{\link[=ogr2ogr]{ogr2ogr()}} for vector data
}
