% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gdal_formats}
\alias{gdal_formats}
\title{Retrieve information on GDAL format drivers for raster and vector}
\usage{
gdal_formats(fmt = "")
}
\arguments{
\item{fmt}{A character string containing a driver short name. By default,
information for all configured raster and vector format drivers will be
returned.}
}
\value{
A data frame containing the format short name, long name, raster
(logical), vector (logical), read/write flag (\code{ro} is read-only,
\code{w} supports CreateCopy, \verb{w+} supports Create), virtual I/O supported
(logical), and subdatasets (logical).
}
\description{
\code{gdal_formats()} returns a table of the supported raster and vector
formats, with information about the capabilities of each format driver.
}
\note{
Virtual I/O refers to operations on GDAL Virtual File Systems. See
\url{https://gdal.org/user/virtual_file_systems.html#virtual-file-systems}.
}
\examples{
nrow(gdal_formats())
head(gdal_formats())

gdal_formats("GPKG")
}
