% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/page_size.R
\name{font_lcpi}
\alias{font_lcpi}
\title{Calculate lines per inch and characters per inch for font}
\usage{
font_lcpi(font_family = "Courier", font_size = 12, lineheight = 1)
}
\arguments{
\item{font_family}{character(1). Name of a font family. An error
will be thrown if the family named is not monospaced. Defaults
to Courier.}

\item{font_size}{numeric(1). Font size, defaults to 12.}

\item{lineheight}{numeric(1). Line height, defaults to 1.}
}
\value{
named list with \code{cpi} and \code{lpi}, the characters and lines per
inch, respectively.
}
\description{
Calculate lines per inch and characters per inch for font
}
\details{
This function creates opens pdf graphics device  writing to an temporary file,
then utilizes \code{\link[grid:grid.convert]{grid::convertWidth()}} and \code{\link[grid:grid.convert]{grid::convertHeight()}} to calculate
lines per inch and characters per inch for the specified font family, size, and
line height.

An error is thrown if the font is not monospaced (determined by comparing
the effective widths of the \code{M} and \code{.} glyphs).
}
\examples{
font_lcpi()

font_lcpi(font_size = 8)

font_lcpi(font_size = 8, lineheight = 1.1)
}
