% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk_images.R
\name{minibar}
\alias{minibar}
\title{Mini barplots chunk wrapper}
\usage{
minibar(
  value,
  max = NULL,
  barcol = "#CCCCCC",
  bg = "transparent",
  width = 1,
  height = 0.2,
  unit = "in"
)
}
\arguments{
\item{value}{values containing the bar size}

\item{max}{max bar size}

\item{barcol}{bar color}

\item{bg}{background color}

\item{width, height}{size of the resulting png file in inches}

\item{unit}{unit for width and height, one of "in", "cm", "mm".}
}
\description{
This function is used to insert bars into
flextable with functions:
\itemize{
\item \code{\link[=compose]{compose()}} and \code{\link[=as_paragraph]{as_paragraph()}},
\item \code{\link[=append_chunks]{append_chunks()}},
\item \code{\link[=prepend_chunks]{prepend_chunks()}}.
}
}
\note{
This chunk option requires package officedown in a R Markdown
context with Word output format.

PowerPoint cannot mix images and text in a paragraph, images
are removed when outputing to PowerPoint format.
}
\examples{
ft <- flextable(head(iris, n = 10))

ft <- compose(ft,
  j = 1,
  value = as_paragraph(
    minibar(value = Sepal.Length, max = max(Sepal.Length))
  ),
  part = "body"
)

ft <- autofit(ft)
ft
}
\seealso{
\code{\link[=compose]{compose()}}, \code{\link[=as_paragraph]{as_paragraph()}}

Other chunk elements for paragraph: 
\code{\link{as_bracket}()},
\code{\link{as_b}()},
\code{\link{as_chunk}()},
\code{\link{as_equation}()},
\code{\link{as_highlight}()},
\code{\link{as_image}()},
\code{\link{as_i}()},
\code{\link{as_sub}()},
\code{\link{as_sup}()},
\code{\link{as_word_field}()},
\code{\link{colorize}()},
\code{\link{gg_chunk}()},
\code{\link{grid_chunk}()},
\code{\link{hyperlink_text}()},
\code{\link{linerange}()},
\code{\link{lollipop}()},
\code{\link{plot_chunk}()}
}
\concept{chunk elements for paragraph}
