% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gauge.R
\name{gauge}
\alias{gauge}
\alias{gaugeSectors}
\title{Create a gauge component for a dashboard.}
\usage{
gauge(
  value,
  min,
  max,
  sectors = gaugeSectors(),
  symbol = NULL,
  label = NULL,
  abbreviate = TRUE,
  abbreviateDecimals = 1,
  href = NULL
)

gaugeSectors(
  success = NULL,
  warning = NULL,
  danger = NULL,
  colors = c("success", "warning", "danger")
)
}
\arguments{
\item{value}{Numeric value to display}

\item{min}{Minimum numeric value}

\item{max}{Maximum numeric value}

\item{sectors}{Custom colored sectors (e.g. "success", "warning", "danger"). By
default all values are colored using the "success" theme color}

\item{symbol}{Optional symbol to show next to value (e.g. 'kg')}

\item{label}{Optional label to display beneath the value}

\item{abbreviate}{Abbreviate large numbers for min, max, and value
(e.g. 1234567 -> 1.23M). Defaults to \code{TRUE}.}

\item{abbreviateDecimals}{Number of decimal places for abbreviated
numbers to contain (defaults to 1).}

\item{href}{An optional URL to link to. Note that this can be an anchor of
another dashboard page (e.g. "#details").}

\item{success}{Two-element numeric vector defining the range of values to
color as "success" (specific color provided by theme or custom \code{colors})}

\item{warning}{Two-element numeric vector defining the range of values to
color as "warning" (specific color provided by theme or custom \code{colors})}

\item{danger}{Two-element numeric vector defining the range of values to
color as "danger" (specific color provided by theme or custom \code{colors})}

\item{colors}{Vector of colors to use for the \code{success}, \code{warning},
and \code{danger} ranges. Colors can be standard theme colors ("success",
"warning", "danger", "primary", and "info") or any other valid CSS color
specifier. Note that if no custom sector ranges are defined, this parameter
can be a single color value rather than a vector of three values}
}
\description{
A gauge displays a numeric value on a meter that runs between
specified minimum and maximum values.
}
\details{
See the flexdashboard website for additional documentation:
 <https://pkgs.rstudio.com/flexdashboard/articles/using.html#gauges>
}
\examples{
library(flexdashboard)

gauge(42, min = 0, max = 100, symbol = '\%', gaugeSectors(
  success = c(80, 100), warning = c(40, 79), danger = c(0, 39)
))

}
