% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_wrappers.R
\name{fastcpd.variance}
\alias{fastcpd.variance}
\alias{fastcpd_variance}
\title{Find change points efficiently in variance change models}
\usage{
fastcpd.variance(data, ...)

fastcpd_variance(data, ...)
}
\arguments{
\item{data}{A matrix, a data frame or a vector.}

\item{...}{Other arguments passed to \code{\link{fastcpd}}, for example,
\code{segment_count}.}
}
\value{
A class \code{fastcpd} object.
}
\description{
\code{fastcpd_variance} and \code{fastcpd.variance} are wrapper
functions of \code{\link{fastcpd}} to find the variance change. The
function is similar to \code{\link{fastcpd}} except that the data is by
default a matrix or data frame or a vector with each row / element as an
observation and thus a formula is not required here.
}
\examples{
set.seed(1)
p <- 3
result <- fastcpd.variance(
  rbind(
    mvtnorm::rmvnorm(300, rep(0, p), crossprod(matrix(runif(p^2) * 2 - 1, p))),
    mvtnorm::rmvnorm(400, rep(0, p), crossprod(matrix(runif(p^2) * 2 - 1, p))),
    mvtnorm::rmvnorm(300, rep(0, p), crossprod(matrix(runif(p^2) * 2 - 1, p)))
  )
)
summary(result)
}
