% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features.R
\name{features}
\alias{features}
\alias{features_at}
\alias{features_all}
\alias{features_if}
\title{Extract features from a dataset}
\usage{
features(.tbl, .var, features, ...)

features_at(.tbl, .vars, features, ...)

features_all(.tbl, features, ...)

features_if(.tbl, .predicate, features, ...)
}
\arguments{
\item{.tbl}{A dataset}

\item{.var}{An expression that produces a vector from which the features are computed.}

\item{features}{A list of functions (or lambda expressions) for the features to compute. \code{\link[=feature_set]{feature_set()}} is a useful helper for building sets of features.}

\item{...}{Additional arguments to be passed to each feature. These arguments will only be passed to features which use it in their formal arguments (\code{\link[base:formals]{base::formals()}}), and not via their \code{...}. While passing \code{na.rm = TRUE} to \code{\link[stats:cor]{stats::var()}} will work, it will not for \code{\link[base:mean]{base::mean()}} as its formals are \code{x} and \code{...}. To more precisely pass inputs to each function, you should use lambdas in the list of features (\code{~ mean(., na.rm = TRUE)}).}

\item{.vars}{A tidyselect compatible selection of the column(s) to compute features on.}

\item{.predicate}{A predicate function (or lambda expression) to be applied to the columns or a logical vector. The variables for which .predicate is or returns TRUE are selected.}
}
\description{
Create scalar valued summary features for a dataset from feature functions.
}
\details{
Lists of available features can be found in the following pages:
\itemize{
\item \link[=features_by_pkg]{Features by package}
\item \link[=features_by_tag]{Features by tag}
}
}
\examples{
# Provide a set of functions as a named list to features.
library(tsibble)
tourism \%>\% 
  features(Trips, features = list(mean = mean, sd = sd))

# Search and use useful features with `feature_set()`. 

\dontshow{if (requireNamespace("feasts", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(feasts)
\dontshow{\}) # examplesIf}
tourism \%>\% 
  features(Trips, features = feature_set(tags = "autocorrelation"))

# Best practice is to use anonymous functions for additional arguments
tourism \%>\% 
  features(Trips, list(~ quantile(., probs=seq(0,1,by=0.2))))


}
\seealso{
\code{\link[=feature_set]{feature_set()}}
}
