% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.multilayer.R
\name{ergm_LayerLogic}
\alias{ergm_LayerLogic}
\alias{toString.ergm_LayerLogic}
\alias{to_ergm_Cdouble.ergm_LayerLogic}
\title{Internal representation of Layer Logic}
\usage{
ergm_LayerLogic(formula, namemap = NULL)

\method{toString}{ergm_LayerLogic}(x, ...)

\method{to_ergm_Cdouble}{ergm_LayerLogic}(x, ...)
}
\arguments{
\item{formula}{A Layer Logic formula.}

\item{namemap}{A character vector giving the names of the layers
referenced, or \code{NULL}.}

\item{x}{An \code{ergm_LayerLogic} object.}

\item{...}{Additional arguments, currently unused.}
}
\value{
A structure with nonce class
\code{c("ergm_LayerLogic",class(formula))}, comprising the input
\code{formula} and an attribute \code{namemap} containing the \code{namemap}.
}
\description{
Internal representation of Layer Logic
}
\section{Methods (by generic)}{
\itemize{
\item \code{toString(ergm_LayerLogic)}: A method to generate coefficient names
associated with the Layer Logic.

\item \code{to_ergm_Cdouble(ergm_LayerLogic)}: A method to encode and serialize the
Layer Logic into a postfix program understood by the C code.

}}
\keyword{internal}
