% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-coefficients.r
\name{interactionPlot}
\alias{interactionPlot}
\title{Compare two interaction matrices}
\usage{
interactionPlot(
  estimated.adjacency.matrix,
  true.adjacency.matrix,
  excluded.interactions = NULL,
  labels = TRUE,
  noplot = FALSE,
  legend = TRUE,
  ...
)
}
\arguments{
\item{estimated.adjacency.matrix}{the interaction matrix of the model of interest.}

\item{true.adjacency.matrix}{the interaction matrix of the model to compare with (usually, the one used for simulating the data).}

\item{excluded.interactions}{a binary species x species matrix telling which interactions were excluded \emph{a priori}.}

\item{labels}{logical. Add default axis labels and title?}

\item{noplot}{logical. Do plots? If TRUE, it will return the accuracy statistics only.}

\item{legend}{logical. Plot legend?}

\item{...}{further arguments to pass to \code{plot}.}
}
\value{
A vector with accuracy statistics.
}
\description{
Visually compare two interaction (adjacency) matrices and return accuracy statistics
}
