% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{ec_util_choice_to_long}
\alias{ec_util_choice_to_long}
\title{Convert a vector of choices to long format}
\usage{
ec_util_choice_to_long(myvec, all_index)
}
\arguments{
\item{myvec}{A vector of choices, where each element represents the index of the chosen alternative.}

\item{all_index}{A vector of all the possible alternative indices.}
}
\value{
A tibble with columns 'x', 'task', and 'alt', where 'x' is a binary indicator of whether
the alternative was chosen or not, 'task' is the task index, and 'alt' is the alternative index.
}
\description{
Converts a vector of choices into a long format data frame, where each row represents
a single choice and contains the choice status for each alternative.
}
\examples{
#There are 3 alternatives in this task. 
#Since there are 3 observations in myvec, there are 3 tasks total.
ec_util_choice_to_long(c(1, 2, 1), c(1, 2, 3))

}
